package RePEc::Index::Config;


use strict qw( vars subs );

use vars qw( $OK 
             $HOMEDIR 
             $LOG
             $DATADIR
             $SETTINGS 
             @COLLECTIONS
             %COLLECTIONS
);

my $home = $RePEc::Index::HOME;

$SETTINGS = {};

sub warning {
  my @text = @_;
  warn "RePEc::Index: @text";
}


sub check_setup {

  my $dir = shift;

  if ( -e $dir
     and -d _
     and -w _ ) {
    # good
  } else {
    warning "home directory $dir doesn't exists or is not a directory or is not writable";
    $OK = 0;
    return $OK;
  }

  $HOMEDIR = $dir;
  $DATADIR   = "$HOMEDIR/data";
  $LOG       = "$HOMEDIR/ri.log";

  if ( -e $DATADIR
     and -d _
     and -w _ ) {
    # OK
  } else {
    warning "data directory $DATADIR is invalid";
  }

  my $backupdir = "$HOMEDIR/backup";
  if ( -e $backupdir
     and -d _
     and -w _ ) {
    # OK
  } else {
    warning "data backup directory $backupdir is invalid";
  }


  load_configuration_file();


  $OK = 1;
  return $OK;

}



if ( not defined $home ) {
  eval {
    require RePEc::Index::local_setup;
  };
  if ( $@ ) {
#    warning "Can't load local setup settings file";
    warn;
  } else {
    $home = $RePEc::Index::local_setup::HOMEDIR;
  }
}

if ( $home ) {
  &check_setup( $home );
}


sub home_dir {
  $home = shift;
  &check_setup( $home );
}




sub load_configuration_file{

  require RePEc::Index::Collections;

  my $coll_file = "$HOMEDIR/collections";

  my $collections = RePEc::Index::Collections::read_configuration( $coll_file );
  if (not $collections ) {
    warn "Can not load collections file: $!";
    return undef;
  }
  $RePEc::Index::COLLECTIONS = $collections;


  # conf file
  my $conf_file = "$HOMEDIR/configuration.pl";

  if ( -e $conf_file ) {
    my $do = do $conf_file;

    if (not $do) {
      warn "Error while loading configuration file: $!";
      return undef;
    }
  }

#   $SETTINGS{colons_in_filenames} = $colons_in_filenames;

  # for each configuration parameter
  for my $par ( qw( log_level ) ) {
    $SETTINGS->{$par} = ${ "RePEc::Index::Config::$par" };
  }

}


1;
