use ARDB::Test;
use CGI;
use CGI::Untaint;

$ENV{QUERY_STRING}   = 'e1=ab&e2=e@b.c&e3=fd@%20geo.org&e4=mail@mail.com&e5=346234@234234.42';
$ENV{REQUEST_METHOD} = 'GET';

my $query = new CGI;
my $untaint = new CGI::Untaint ( {INCLUDE_PATH => 'ACIS/Web'}, $query -> Vars );

my $mail;
my $err;

$mail = $untaint -> extract ( -as_email => 'e1' );
$err  = $untaint -> error ;

test ( $err, $err );
test ( not( defined( $mail )), $mail );


$mail = $untaint -> extract ( -as_email => 'e2' );
$err  = $untaint -> error ;

test ( $err, $err );
test ( not( defined( $mail )), $mail );


$mail = $untaint -> extract ( -as_email => 'e3' );
$err  = $untaint -> error ;

test ( $err, $err );
test ( not( defined( $mail )), $mail );


$mail = $untaint -> extract ( -as_email => 'e4' );
$err  = $untaint -> error ;

test ( (not $err), $err );
test ( defined( $mail ), $mail );


$mail = $untaint -> extract ( -as_email => 'e5' );
$err  = $untaint -> error ;

test ( $err, $err );
test ( not( defined( $mail )), $mail );




__END__

$ENV{QUERY_STRING}   = 'login=s&password=pass';

$query = new CGI;
$untaint = new CGI::Untaint ( {INCLUDE_PATH => 'ACIS/Web'}, $query -> Vars );

$mail = $untaint -> extract (-as_email => 'login');

test( not $mail );

print "mail: $mail, error: ", $untaint->error() , "\n";



$ENV{QUERY_STRING}   = 'login=polnaya%20hernya@acis&password=pass';

$query = new CGI;
$untaint = new CGI::Untaint ( {INCLUDE_PATH => 'ACIS/Web'}, $query -> Vars );

$mail = $untaint -> extract (-as_email => 'login');

test $mail eq 'polnaya%20hernya@acis', "$untaint->{_ERR}: '$mail'";



$ENV{QUERY_STRING}   = 'login=not%20v@lid%20e.mail&password=pass';

$query = new CGI;

$untaint = new CGI::Untaint ( {INCLUDE_PATH => 'ACIS/Web'}, $query -> Vars );

$mail = $untaint -> extract (-as_email => 'mail');

test $mail, "$untaint->{_ERR}: '$mail'";


$mail = $untaint -> extract (-as_email => 'login');

test $mail eq 'not%20v@lid%20e.mail', "$untaint->{_ERR}: '$mail'";

