package main;

use ACIS::Web;
use ACIS::Common;

use ARDB::Test;

use CGI;
use BerkeleyDB;

use strict;
use warnings;

use vars qw( $home $acis_web $form_data );

use Data::Dumper;

$home = 'home';

#$ACIS::DEBUG = 'on';

print "\n################## initial registration screen ##################\n\n";

$ENV{QUERY_STRING} = '';

$ENV{HTTP_HOST}   = 'acis';
$ENV{SERVER_PORT} = 80;
$ENV{REQUEST_URI} = '/new-user';
$ENV{REMOTE_ADDR} = '100.90.90.1';
$ENV{REQUEST_METHOD} = 'GET';

&launch_test; # user should input data

test not $acis_web -> {'redirect-to'};
test not $acis_web -> {'session'};
test not $acis_web -> {'request'} -> {'session-id'};


$ENV{QUERY_STRING} =
 'email=admin&first-name=aaa&second-name=bbb&last-name=ccc&dd';

&launch_test; # email incorrect

test not $acis_web -> {'redirect-to'};
test not $acis_web -> {'session'};
test not $acis_web -> {'request'} -> {'session-id'};
test $acis_web -> errors, Dumper $acis_web -> errors;

$ENV{QUERY_STRING} =
  'email=admin@acis.com&first-name=aaa&second-name=bbb&last-name=ccc';

&launch_test; # all correct

test $acis_web -> {'redirect-to'} =~ /additional/;
test $acis_web -> {'session'};
test $acis_web -> {'request'} -> {'session-id'};
test $form_data;
test not $acis_web -> errors;

my $session_id = $acis_web -> {'request'} -> {'session-id'};

print "\n################## additional registration screen ##################\n\n";

$ENV{REQUEST_URI} = "/new-user/additional!$session_id";
$ENV{QUERY_STRING} = '';

&launch_test; # load session, no redirect, no user input

test not $acis_web -> {'redirect-to'};
test $acis_web -> {'session'};
test $acis_web -> {'request'} -> {'session-id'};
test ref $form_data -> {'name-variations'} eq 'ARRAY';
test not $acis_web -> errors;

$ENV{REQUEST_URI} = "/new-user/additional!$session_id";
$ENV{QUERY_STRING} =
  'name-variations=James+Bond%0D%0ABond%2C+James%0D%0AJ.+Bond%0D%0ABond%2C+J.%0D%0A'.
  '&interests=some%20fuck.n%20interests%2C%20comma%20separated%20shit';

&launch_test;

test $acis_web -> {'redirect-to'} =~ /affiliation/, $acis_web -> {'redirect-to'};
test $acis_web -> {'session'};
test $acis_web -> {'request'} -> {'session-id'};
test $form_data;
test not $acis_web -> errors;

print "\n################## affiliation registration screen ##################\n\n";

$ENV{REQUEST_URI} = "/new-user/affiliation!$session_id";
$ENV{QUERY_STRING} = '';

&launch_test;

test not $acis_web -> {'redirect-to'} ;
test $acis_web -> {'session'};
test $acis_web -> {'request'} -> {'session-id'};
test not $acis_web -> errors;

$ENV{REQUEST_URI} = "/new-user/affiliation!$session_id";
$ENV{QUERY_STRING} = 'action=search&search-what=org&search-by=name';

&launch_test;

test not $acis_web -> {'redirect-to'} ;
test $acis_web -> {'session'};
test $acis_web -> {'request'} -> {'session-id'};
#test $acis_web -> {'entered-user-data'};
test $acis_web -> errors, Dumper $acis_web -> errors;

$ENV{REQUEST_URI} = "/new-user/affiliation!$session_id";
$ENV{QUERY_STRING} = 'affiliation=&action=search&search-what=org&search-by=name';

&launch_test;

test not $acis_web -> {'redirect-to'} ;
test $acis_web -> {'search'} ;
test not $acis_web -> errors;


##################### tests ends here #################################

sub handle_request
 {
  my $self = shift;
  my $config = $self -> {'config'};
  my $screen_name = $self -> request -> {'screen'};
  
  $screen_name = 'index'
   unless ($screen_name);
  
  $self -> add_to_process_queue ($screen_name);
  $self -> set_presenter ($screen_name);
  
  while (my $processor = $self -> next_processor)
   {
    debug "launch '$processor'";
    
    no strict;
    &$processor ($self);
   }
  
  debug "processors finished";
  
  $self -> session -> save ($self -> request -> {'session-id'})
   if $self -> session;

  debug "session saved, if any";
  
  $self -> {'user_data'} -> save
   if $self -> {'user_data'};
  
 }

sub launch_test
 {
  CGI::initialize_globals;
  
  ### iku: fixing home paramter
  $acis_web = new ACIS::Web ( 'home' => $home );
  handle_request ($acis_web); # user should input data
  
  
  $form_data = $acis_web -> variables -> {'form-data'};
 }
