package My::ACIS;

sub logoff
{
 my $acis_web = shift;
 
 my $home = $acis_web -> {'home'};
 unlink $home . '/sessions/pAB101';
 $acis_web -> {'session'} = undef;
} 

package main;

use ACIS::Web;
use Carp::Assert;

use ARDB::Test;

use Data::Dumper;

use CGI;
use BerkeleyDB;

my $home = 't/home';

my $db_path = 'users.db';
  
my $db_env => new BerkeleyDB::Env
 (
  -Home => $home,
  -ErrFile => "db.err",
  -Verbose => 1
 );
  
my $db = new BerkeleyDB::Hash
 (
  -Filename => $db_path,
  -Flags    => DB_CREATE,
  -Env      => $db_env
 );
  
die "cannot open file $db_path: $! $BerkeleyDB::Error\n"
 unless defined $db;
  
my $id_and_pass = "pAB101\0pass";
  
my $failure = $db -> db_put ('admin@acis.com', $id_and_pass);
  
if ( $failure )
 {
  die "can't store 'admin\@acis.com'" ;
 }

$failure = $db -> db_get ('admin@acis.com', $id_and_pass);
  
if ( $failure )
 {
  die "can't get 'admin\@acis.com'" ;
 }
  
my($id, $db_pass) = ($id_and_pass =~ /(.*)\0(.*)/);
  
#$ACIS::DEBUG = 'on';

$ENV{QUERY_STRING} = '';

$ENV{HTTP_HOST}   = 'acis';
$ENV{SERVER_PORT} = 80;
$ENV{REQUEST_URI} = '/contributions!pAB101';
$ENV{REMOTE_ADDR} = '100.90.90.1';


my $acis_web = new ACIS::Web ($home);
# "query string: $ENV{QUERY_STRING}";
handle_request ($acis_web); # unauthorized access
# $acis_web -> {presenter} -> {file} . ", expected 'login'";
test $acis_web -> {presenter} -> {file} =~ /login/;

$ENV{QUERY_STRING}   = 'login=admin@acis.com&password=pass';
$ENV{REQUEST_METHOD} = 'GET';

$acis_web = new ACIS::Web ($home);
handle_request ($acis_web); # login
# $acis_web -> {presenter} -> {file} . ", expected 'contributions'";
test $acis_web -> {presenter} -> {file} =~ /contributions/;

$ENV{QUERY_STRING} = '';
$ENV{REQUEST_URI}  = '/confirm!pAB101';
$ENV{REMOTE_ADDR}  = '100.90.90.1';

$acis_web = new ACIS::Web ($home);
handle_request ($acis_web); # continue
# $acis_web -> {presenter} -> {file} . ", expected 'confirmed'";
test $acis_web -> {presenter} -> {file} =~ /confirmed/;

$ENV{QUERY_STRING} = 'login=admin@acis.com&password=pass';
$ENV{REQUEST_URI}  = '/contributions!pAB101';
$ENV{REMOTE_ADDR}  = '100.90.90.2';

$acis_web = new ACIS::Web ($home);
handle_request ($acis_web); # other user
# $acis_web -> {presenter} -> {file} . ", expected 'login'";
test $acis_web -> {presenter} -> {file} =~ /login/;

$ENV{QUERY_STRING} = '';
$ENV{REQUEST_URI}  = '/exit!pAB101';
$ENV{REMOTE_ADDR}  = '100.90.90.1';

$acis_web = new ACIS::Web ($home);
handle_request ($acis_web); # logoff
# $acis_web -> {presenter} -> {file} . ", expected 'exit'";
test $acis_web -> {presenter} -> {file} =~ /exit/;

sub handle_request
 {
  my $acis_web = shift;

  my $config = $acis_web -> {'config'};
  
  my $screen_name = $acis_web -> request -> {'screen'};
  
  $screen_name = 'index'
   unless ($screen_name);
  
  $acis_web -> add_to_process_queue ($screen_name);
  $acis_web -> set_presenter ($screen_name);
  
  #-         
  
  while (my $processor = $acis_web -> next_processor)
   {
    no strict;
    &$processor ($acis_web);
   }
  
  if (defined $acis_web -> session)
   {
    $acis_web -> session -> save ($acis_web -> request -> {'session-id'});
   }
 }



use ACIS::Data::DumpXML qw(dump_xml);

$ACIS::Data::DumpXML::ROOT_NAME = 'user-data';
#$Data::DumpXML::DTD_LOCATION = '';
#$Data::DumpXML::SIMPLE_VIEW = 1;

my $filename = "./test-au.xml";

my $xml = dump_xml($acis_web);


open F, ">$filename";
print F $xml;
close F;

test 1;
