#!/usr/bin/perl

use ARDB;

use ARDB::Test;

use Carp::Assert;

$ARDB::DEBUG = 1;

my $ardb = ARDB -> new( "home" );
test $ardb;

my @handles;

my $sql = $ardb -> {sql_object};

$sql -> prepare ('select handle from documents limit 50');
my $res = $sql -> execute ();

assert( $res ); 

while ( $res->{row} )
 {
  push @handles, $res -> get('handle');
  $res->next;
 }

die if not scalar @handles;

test scalar (@handles), scalar (@handles);

foreach (@handles)
 {
  test $ardb -> delete_record ($_);
 }

my $statement = 'select * from documents where'.
   ' handle=? or ' x scalar @handles;
   
$statement =~ s/or\s$//;
 
$sql -> prepare ($statement);
$res = $sql -> execute (@handles); 

test not $res -> {'rows'};

$statement = 'select * from relations where'.
             ' source=? or ' x scalar @handles;

$statement =~ s/or\s$//;

$sql -> prepare ($statement);
$res = $sql -> execute (@handles);

assert $res;

test not $res -> {'rows'};


