# -*- Mode:perl -*-

use strict;
use Carp::Assert;

use Data::Dumper;

use ARDB::Test;
use ARDB;

$ARDB::DEBUG = 1;

my $ardb = ARDB -> new( "home" );
test $ardb;

my $handle = 'RePEc:boc:bocode:s369901xxx';

use ARDB::Record::ReDIF;

use vars '%rels';

{ 
  no strict;

  undef &ARDB::Record::ReDIF::add_relationship;

  eval '
    sub ARDB::Record::ReDIF::add_relationship { 
      my $self = shift;
      
      my $relationship = shift;
      my @things = @_;
      
      push @{ $::rels {$relationship} }, @things;
    }
  ';

}
my $rec = $ardb -> get_unfolded_record ( $handle ) ;

test $rec;

test scalar keys %::rels, "relations list \%::rels\n".Dumper \%::rels;

test $rec->id;

test $rec->id eq $handle;

test $rec->type;

foreach (keys %$rec)
 {
  if (/^(.*)_rel$/)
   {
    print "### relation '$1' retrieved from '$handle' ###\n";
    test scalar @{ $rec -> {$_} }, "found ".scalar @{ $rec -> {$_} }." relations";
    print Dumper $rec -> {$_};
   }
 }

