#!/usr/bin/perl

use strict;
use warnings;

use AppConfig;

use ReDIF::Parser;
use ARDB;

my $ardb_object = new ARDB;

$ardb_object -> init_config;

my $dir = shift @ARGV || "/home/ivan/data/RePEc/remo/per/pers";

process_dir ( $dir );

sub process_dir
 {
  my $dir = shift;
  
  print "processing $dir\n";

  opendir TEMPLATE_DIR, $dir;
  my @files = readdir TEMPLATE_DIR;
  closedir TEMPLATE_DIR;
  
  my @rdf_files = grep { /\.rdf$/i and $_ = "$dir/$_" and -f $_ } @files;
  foreach my $file_name ( @rdf_files )
   {
    print "> ", $file_name, "\n";
    ReDIF::Parser::open_file ( "$file_name" );
    my $template = ReDIF::Parser::get_next_template();
    $ardb_object -> process_record ( $template );
    print "short id: ", $template -> {SHORT_ID}, "\n";
   }

  my @dirs = grep { !/^\.+$/ and $_ = "$dir/$_" and -d $_ } @files;
  foreach my $dir_name ( @dirs )
   {
    process_dir ($dir_name);
   }

 }