package ARDB::Plugin::Processing::ShortIDs;

use ARDB::Plugin::Processing;
use RePEc::ShortIDs;
use ARDB::Common;

use strict;

use base ( 'ARDB::Plugin::Processing' );

sub get_record_types {
  my $self = shift;

  return [ 'ReDIF-Person 1.0', 
	   'ReDIF-Software 1.0', 
	   'ReDIF-Paper 1.0', 
	   'ReDIF-Article 1.0', 
	   'ReDIF-Chapter 1.0', 
	   'ReDIF-Book 1.0', 
	   'ReDIF-Archive 1.0',
	   'ReDIF-Series 1.0',
];
}



sub process_record {
  my $self = shift;
  my $record = shift;
  
  my $id = $record -> id;

  debug "try to resolve short id for record '$id'";
  
  RePEc::ShortIDs::process_record ( $record, 1 );
  
  my $short_id = RePEc::ShortIDs::resolve_handle ( $id );
  
  $record -> {SHORT_ID} = $short_id
    if ( defined ( $short_id ) );
}



1;

=head1 NAME

ARDB plugin Processing::ShortIDs - interface to a RePEc::ShortIDs module

=head1 DESCRIPTION

Processing::ShortIDs - plugin     
RePEc::ShortIDs.    ARDB::Plugin::Processing  
2  - get_record_types (      )  
process_record

=head1 AUTHOR

Ivan Baktcheev, with support from Ivan Kurmanov

=head1 SEE ALSO

L<ARDB::Plugins> L<ARDB::Plugin::Processing> and L<RePEc::ShortIDs>

=cut
