package ARDB::Plugin::Processing::HoPEc;

use ARDB::Plugin::Processing;

use strict;
use vars qw ( @ISA );

@ISA = ('ARDB::Plugin::Processing');

sub get_record_types
 {
  return [];#'ReDIF-Person 1.0', 'ReDIF-Paper 1.0', 'ReDIF-Article 1.0'];
 }

sub require
 {
  return ['ARDB::Plugin::Processing::ShortIDs'];
 }

sub process_record
 {
  my $self = shift;
  my $record = shift;
  
  RePEc::ShortIDs::process_record ( $record, 1 );
  my $short_id = RePEc::ShortIDs::resolve_handle ( $record -> {handle} -> [0] );
  $record -> {SHORT_ID} = $short_id
   if ( defined ( $short_id ) );
 }

#sub status
# {
#  my $self = shift;
#  my $config_object = shift;
#
#  $self -> init_config ( $config_object );
#
# }
#
#sub init_config
# {
#  my $self = shift;
#  my $config_object = shift;
#
#  $config_object -> parse_config ( $self -> { plugins_path } );
# }

1;
