package ACIS::Web::UserData;

use strict;

use ACIS::Data::DumpXML; # qw( dump_xml )
use ACIS::Data::DumpXML::Parser;

use ACIS::Common;

sub new {

  my $class = shift;

  my $self = {
	      'owner'   => { },
	      'records' => [ { }, ],
	     };

  bless $self, $class;
  return $self;
}


sub load {
  my $class = shift;
  my $path  = shift;
  
  my $self  = ACIS::Data::DumpXML::Parser -> new -> parsefile ( $path );
#  $self -> {'internal-variables'} -> {'path'} = $path;
  
  bless $self, $class
   if ref $self eq 'HASH';
   
  return $self;
}
 

sub changed
 {
  my $self = shift;
  $self -> {'internal-variables'} -> {'changed'} = 1;
 }


sub dump_xml
 {
  my $self = shift;
  
  return ACIS::Data::DumpXML::dump_xml ($self);
 }
 

sub save {

  my $self = shift;
  my $path = shift; # || $self -> {'internal-variables'} -> {'path'};
  
#  debug 'try saving user-data';
#  
#  return
#   unless $self -> {'internal-variables'} -> {'changed'};
  
  debug "user-data changed, try to save into '$path'";
  
  delete $self -> {'internal-variables'};
  
#  my $ref = shift;

  my $xml = $self -> dump_xml;
  
  open  TO_SAVE, ">:utf8", $path;
  print TO_SAVE $xml;
  close TO_SAVE;

  debug "written userdata " . length( $xml ) , " characters to $path";

}
 
1;
