package ACIS::Web::Session;

use strict;

use Data::Dumper;
use Carp::Assert;

use ACIS::Common;

use ACIS::Data::DumpXML qw(dump_xml);

use Storable;


sub load {
  my $filename = shift;

  my $self;
  
  if (not -f $filename) {
    return undef;
  }
  
  eval { $self = retrieve ($filename); };
  
  if ($@) {
    debug "loading a session failed: $@";
    return undef;
  }

  $self -> {'.filename'} = $filename;

  bless $self;
  
  debug "loaded session from $filename";
  
  return $self;
}



sub not_yet_expired {
  my $self = shift;

  my $expirytime = $self ->{'.lifetime'};  ## in seconds

  return 1 if not $expirytime;

  my $filename = $self->{'.filename'};
  
  my $mtime = ( stat( $filename ) )[9];

  my $now = time();

  if( $now - $mtime > $expirytime ) {
    ###  too old
    return undef;

  } else {
    return 1;

  }
}



sub very_old {
  my $self = shift;

  my $filename = $self->{'.filename'};
  my $mtime    = ( stat( $filename ) )[9];
  my $now      = time();

  if( $now - $mtime > 60 * 60 * 24 * 1 ) {  ### two days old
    ###  too old
    return 1;
  } else {
    return 0;
  }
}


sub filename {
  my $self = shift;
  return $self -> {'.filename'};
}  


sub lock {
  my $self = shift;
  my $lock = shift;

  if ( $lock and -f $lock ) {
    $self->{'.lock'} = $lock;
  } else {
    return $self -> {'.lock'};
  }
}


sub close {

  my $self = shift;
  
  my $file = $self -> {'.filename'};
  unlink $file;

  my $lock = $self -> {'.lock'    };
  if( $lock ) {
    unlink $lock;
  }


  $self -> { '.closed' } = 1;

}
  

sub closed {
  my $self = shift;
  return $self -> {'.closed'};
}



sub new {

  my $class = shift;
  my $sid   = shift;
  my $file  = shift;
  my $type  = shift;
  my $owner = shift;
  my $expire = shift;  # in minutes


      
  assert( $owner->{login} );
#  assert( $owner->{name}  );
  assert( $owner->{IP}    );
  
  my $self = {
	      '.id'       => $sid,
	      '.owner'    => $owner,
	      '.type'     => $type,
	      '.filename' => $file,
	      '.lifetime' => $expire * 60,
	     };

  bless $self, $class;
  
  return $self;
}



sub id { 
  my $self = shift;
  return $self->{'.id'};
}

sub type { 
  my $self = shift;
  return $self->{'.type'};
}


sub owner { 
  my $self = shift;
  return $self->{'.owner'};
}


sub save  {
  my $self     = shift;
  my $filename = shift || $self -> {'.filename'};

  if ( $self -> {'.closed'} ) {
    return;
  }
  store $self, $filename;
}
 



### XXX logically belongs to an ACIS-specific session-class, not to the general class

sub current_record { 
  my $self = shift;
  
  my $userdata = $self->{'user-data'};

  if ( defined $userdata
       and defined $userdata -> {'records'}
       and scalar @{ $userdata -> {'records'} } 
     ) {

    my $rec_no = $self -> {'current-record-number'} || 0 ;
    
    $self -> {'current-record-number'} = $rec_no;
    
    return $userdata -> {'records'} -> [$rec_no];
  }

  return undef;
  assert( 0, "no userdata or no records" );
 
}





###############   t h r o w   a w a y   ###########################


 
1;
