package ACIS::UserData::User::Record;

use strict;

use base ( 'ARDB::Record' );

sub id
 {
  my $self = shift;
  
  return $self -> {'login'};
 }
#   /.

sub type
 {
  return 'acis-user';
 }
#   .

sub get_value
 {
  my $data = shift;
  my $path  = shift;
  
  my @path  = split '/', $path;
  foreach (@path)
   {
    $data = $data -> {$_};
   }
  
  if (ref $data eq 'ARRAY')
   { return @$data; }
  
  return $data;
  
 }

#      ,  
# SPEC   .  SPEC   
# ARDB.      XPath,  author/name,
#   -    -    -- 
# ,      - .

# ,  ARDB  get_unfolded_record() 

sub add_relationship
 {
  my $self     = shift;
  my $relation = shift;
  my $object   = shift;
  
  my $relations = $self -> {'ardb-record'} -> {'relations'};
  
  if (ref $relations -> {$relation} eq 'ARRAY')
   {
    push @{$relations -> {$relation}}, $object;
   }
  else
   {
    $relations -> {$relation} = [];
    push @{$relations -> {$relation}}, $object;
   } 
 }

#      .   ,
#   ARDB    
#   ,       
# - ...       --  
#  .

sub set_view
 {
  my $self = shift;
  my $view = shift;
  
  $self -> {'ardb-record'} -> {'view'} = $view;
 }
#  "" ,      
# .

#  
sub view
 {
  my $self = shift;
  
  return $self -> {'ardb-record'} -> {'view'};
 }
#    ,     . 
# .

sub get_relationship
 {
  my $self     = shift;
  my $relation = shift;
  
  my $relations = $self -> {'ardb-record'} -> {'relations'};
  
  if (ref $relations -> {$relation} eq 'ARRAY')
   {
    return @{$relations -> {$relation}};
   }
  else
   {
    return undef;
   } 
 }
#    ,     
# .   .
1;