<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes='exsl'
 version="1.0">
  
  <xsl:import href='../general/pages.xsl'/>
  <xsl:import href='../general/forms.xsl'/>
  
  <xsl:template match='/data'>
    <xsl:call-template name='page'>
      <xsl:with-param name='title'>thanks</xsl:with-param>

      <xsl:with-param name='content'>
        <h1>Good bye</h1>

        <xsl:call-template name='show-status'/>
        
        <xsl:if test='$success'>
        
        <p>Your changes saved and session closed.</p>

        <xsl:if test='$record-about-owner'>
          <p>Check your profile page at <a href='{$response-data/permalink}'>this</a> URL.</p>
        </xsl:if>

        <xsl:if test='$advanced-user'>
          <p>Written (updated) profile pages:</p>

          <ul>
            <xsl:for-each select='$response-data/saved-profiles/list-item'>
              <li>
              <a href='{link/text()}'><xsl:value-of select='name'/></a>
              </li>
            </xsl:for-each>
          </ul>

        </xsl:if>
      </xsl:if>

      <xsl:if test='not( $success )'>

        <p>You changed nothing, so we had nothing to save this time.</p>        

      </xsl:if>
      

    </xsl:with-param>
  </xsl:call-template>
  
</xsl:template>


</xsl:stylesheet>
