<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">


<!-- GLOBAL VARIABLES  --> 

<!-- main ones -->
 
<xsl:variable name='root'       select='/'/>
<xsl:variable name='system'     select='/data/system'/>
<xsl:variable name='config'     select='/data/system/config'/>
<xsl:variable name='request'    select='/data/request'/>
<xsl:variable name='response'   select='/data/response'/>

<!-- configuration -->

<xsl:variable name='base-url'   select='$config/base-url/text()'/>
<xsl:variable name='css-url'    select='$config/css-url/text()'/>
<xsl:variable name='help-url'   select='$config/help-url/text()'/>
<xsl:variable name='site-name'  select='$config/site-name/text()'/>
<xsl:variable name='site-name-long' select='$config/site-name-long/text()'/>
<xsl:variable name='admin-email'    select='$config/admin-email/text()'/>
<xsl:variable name='system-email'   select='$config/system-email/text()'/>
<xsl:variable name='debug-mode' select='$config/debug/text()'/>
<xsl:variable name='problem-report-url' select='$config/problem-report-url/text()'/>


<!-- request parts -->

<xsl:variable name='session'    select='$request/session'/>
<xsl:variable name='user'       select='$request/user'/>

<!-- request context and details -->

<xsl:variable name='session-id'   select='$session/id/text()'  />
<xsl:variable name='session-type' select='$session/type/text()'/>
<xsl:variable name='current-record' select='$session/current-record'/>

<xsl:variable name='record-id'    select='$current-record/id/text()'/>
<xsl:variable name='record-type'  select='$current-record/type/text()'/>
<xsl:variable name='record-name'  select='$current-record/name/text()'/>

<xsl:variable name='user-name'    select='$user/name/text()'/>
<xsl:variable name='user-login'   select='$user/login/text()'/>
<xsl:variable name='user-type'    select='$user/type/text()'/>
<xsl:variable name='user-pass'    select='$user/pass/text()'/>

<xsl:variable name='form-input'   select='$request/form/input'/>

<xsl:variable name='request-screen'    select='$request/screen/text()'/>



<!-- response details -->

<xsl:variable name='error'   select='$response/error/text()'/>
<xsl:variable name='message' select='$response/message/text()'/>
<xsl:variable name='success' select='$response/success/text()'/>

<xsl:variable name='response-data' select='$response/data'/>

<xsl:variable name='form-action' select='$response/form/action/text()'/>
<xsl:variable name='form-values' select='$response/form/values'/>
<xsl:variable name='form-errors' select='$response/form/errors'/>


<!--  other utility variables  -->

<xsl:variable name='any-errors' select='$error or $form-errors//list-item'/>


<xsl:variable name='record-about-owner-flag'>
  <xsl:choose>
    <xsl:when test='$current-record/about-owner/text()="yes"'>yes</xsl:when>
  </xsl:choose>
</xsl:variable>

<xsl:variable name='record-about-owner' select="string-length( $record-about-owner-flag )"/>


<!--  XXX I need to have simple-user flag variable -->

<xsl:variable name='advanced-user'/>


<!--  utility URLs  -->

<xsl:variable name='menu-url'>
  <xsl:value-of select='$base-url'/>/welcome!<xsl:value-of select='$session-id'/>
</xsl:variable>


<!--

<xsl:template name='email'>
  <xsl:param name='address'/>
  <xsl:param name='label' select='$address'/>
  
  <xsl:variable name='userpart' select='substring-before( $address, "@" )'/>
  <xsl:variable name='hostpart' select='substring-after( $address, "@" )'/>

  <a href='mailto:[[{$userpart}&#xff20;{$hostpart}]]'><xsl:value-of select='$label'/></a>

</xsl:template>
-->


</xsl:stylesheet>