<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:import href='../general/pages.xsl'/>
  <xsl:import href='../general/forms.xsl'/>


  <!--    v a r i a b l e s    -->

  <xsl:variable name='affiliations' select='$response-data/affiliations'/>
  <xsl:variable name='search'       select='$response-data/institution-search'/> 
  <xsl:variable name='found-items'  select='$search/items'/> 
  <xsl:variable name='search-what'  select='$form-values/search-what/text()'/> 


  <!--   u t i l i t y   t e m p l a t e   -->

  <xsl:template name='show-institutions'>
    <xsl:param name='list'/>
    <xsl:param name='mode'/>
    
    <xsl:for-each select='$list/list-item' xml:space='preserve'>
      <li class='institution'>

      <form xsl:use-attribute-sets='form' class='narrow'>
        <div>
          <xsl:value-of select='name'/>
          <input type='hidden' name='handle' value='{handle}'/>
          <input type='hidden' name='name'   value='{name}'/>
          <input type='submit' name='action' value='{$mode}'/>

          <small>
            <ul class='institution-details'>
        <xsl:if test='name-english/text()'>
          <li>English name: <xsl:value-of select='name-english/text()'/></li>
        </xsl:if
        ><xsl:if test='location/text()'>
          <li>located in: <xsl:value-of select='location/text()'/></li>
        </xsl:if
        ><xsl:if test='homepage'>
          <li><a href='{homepage}'>website</a></li>
        </xsl:if
        ><xsl:if test='email/text()'>
          <li>email: <xsl:value-of select='email/text()'/></li>
        </xsl:if
        ><xsl:if test='postal/text()'>
          <li>postal address: <xsl:value-of select='postal/text()'/></li>
        </xsl:if
        ><xsl:if test='phone/text()'>
          <li>phone: <xsl:value-of select='phone/text()'/></li>
        </xsl:if
        ><xsl:if test='fax/text()'>
          <li>fax: <xsl:value-of select='fax/text()'/></li>
        </xsl:if
        ><xsl:if test='submitted-by/text()'>
          <li>submitted by: <xsl:value-of select='submitted-by/text()'/></li>
        </xsl:if>
        <!-- XXX not all fields show here -->

            </ul>
          </small>
        </div>
      </form>


    </li>

    </xsl:for-each>
  </xsl:template>




  <!--   n o w   t h e   p a g e   t e m p l a t e    -->

  
  <xsl:template match='/data'>
    
    <xsl:variable name='content' xml:space='preserve'>

        <h1>Affiliation profile</h1>

        <xsl:if 
          test='$search-what or $affiliations/list-item'>

          <form xsl:use-attribute-sets='form' class='narrow'>
            <p>

            <xsl:if test='$search-what'
            >Search found <xsl:value-of select='$search/results/text()'/>
            institution(s). 
            <xsl:if test='number( $search/results/text() )'>
              The results are 
              <a href='#search-results'>below</a>.
              <!-- Jump to <a href='#search-results'>the results</a>. -->
            </xsl:if>
            </xsl:if>

            <xsl:if test='$affiliations/list-item'>
              <input type='submit' name='action' value='Continue'/>
              if you are done with it.
            </xsl:if>

            </p>

          </form>


          <xsl:if test='""'>
          <p>
            <xsl:if test='number( $search/results/text() )'
            >Search found <xsl:value-of select='$search/results/text()'/>
            institution(s).  <a href='#search-results'>Jump</a> to the results.
            <!-- Jump to <a href='#search-results'>the results</a>. -->
            </xsl:if>

            <xsl:if test='$affiliations/list-item'>
             <a onclick='javascript:document.getElementById("continue").submit()' 
               href='#top'  title='may not work in all browsers'
              >Continue</a> if you are done with affiliations.
            </xsl:if>

            <!-- href='#continue' -->
          </p>
          </xsl:if>

        </xsl:if>

        <!--
            <form xsl:use-attribute-sets='form' class='narrow' style='display: inline'>
              <div style='display: inline'>
                <input type='hidden' name='action' value='continue'/>
              <input type='submit' name='press' value='continue'/> if you are done.</div>
            </form>
        </xsl:if>
        -->

        <xsl:call-template name='show-status'/>
        
        <h2>Now:</h2>
        
          <xsl:if test='$affiliations/list-item'>
            <ul class='institutions'>
              <xsl:call-template name='show-institutions' xml:space='default'>
                <xsl:with-param name='list' select='$affiliations'/>
                <xsl:with-param name='mode' select='"remove"'/>
              </xsl:call-template>
              <!--  <xsl:apply-templates select='affiliations'/>  -->
            </ul>
          </xsl:if>
          <xsl:if test='not( $affiliations/list-item )'>
            <p>You are currently not associated with any organization.</p>
          </xsl:if>
      

        <xsl:call-template name='fieldset'><xsl:with-param name='content'>
        <form xmlns='http://x' xsl:use-attribute-sets='form' class='narrow'>

          <h2>Search:</h2>
        
          <p>
            <input type='hidden' name='action' value='search'/>
            <input name='search-what' value='{$search-what}'/>
            <input type='submit' value='SEARCH'/>
            
            <br/>
            <input type='radio' name='search-by' id='search-by-location' value='location'/>
            <label for='search-by-location'>by location</label>

            <label for='search-by-name'>
            <input type='radio' name='search-by' id='search-by-name' value='name' checked='1'/> 
              by name</label>
          </p>
          
        </form> 
        </xsl:with-param></xsl:call-template> <!-- /fieldset -->
                
   
        <xsl:if test='$search'>

          <xsl:if test='count($found-items/list-item)'>
            <form xsl:use-attribute-sets='form' class='narrow'>
              <p><input type='submit' name='action' value='CONTINUE'/></p>
            </form>
          </xsl:if>

     
          <h2>Search: found <xsl:value-of select='$search/results/text()'/> records.</h2>
     
          <xsl:if test='count($found-items/list-item)'>
       
            <ul class='institutions' id='search-results'>
              <xsl:call-template name='show-institutions' xml:space='default'>
                <xsl:with-param name='list' select='$found-items'/>
                <xsl:with-param name='mode' select='"add"'/>
              </xsl:call-template>
            </ul>

          </xsl:if>
     
        </xsl:if>
  
        <xsl:variable name='new-inst-url' xml:space='default'>
          <xsl:choose>
            <xsl:when test='$session-type = "new-user"'>
              <xsl:value-of select='$base-url'/>/new-user/new-institution!<xsl:value-of select='$session-id'/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select='$base-url'/>/new-institution!<xsl:value-of select='$session-id'/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>

        <form xsl:use-attribute-sets='form' class='narrow' id='continue'>
          <p>
            
            <input type='hidden' name='action' value='continue' />
            <input type='submit' name='go' value='CONTINUE' />
              or <a href='{$new-inst-url}'>submit an institution info</a>.
          </p>
        </form>
        
      </xsl:variable>      



      <xsl:choose>
        <xsl:when test='$user-login and $session-type="user"'>

          <xsl:call-template name='registered-user-page' xml:space='default'>
            <xsl:with-param name='title'>affiliation profile</xsl:with-param>
            <xsl:with-param name='content'>
              <xsl:copy-of select='$content'/>
            </xsl:with-param>
          </xsl:call-template>
          
        </xsl:when>
        <xsl:otherwise>
          
          <xsl:call-template name='page' xml:space='default'>
            <xsl:with-param name='title'>affiliation profile</xsl:with-param>
            <xsl:with-param name='content'>
              <xsl:copy-of select='$content'/>
            </xsl:with-param>
          </xsl:call-template>
          
        </xsl:otherwise>
      </xsl:choose>

    </xsl:template>
    
</xsl:stylesheet>