<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">
 
  <xsl:import href='general.xsl'/>

<!-- this template-specific variables: -->

<xsl:template match='/data'>

  <xsl:variable name='institution' select='$response-data/institution'/>

<xsl:call-template name='message'>
  <xsl:with-param name='to'><xsl:value-of select='$config/institutions-maintainer-email'/></xsl:with-param>
  <xsl:with-param name='cc'><xsl:value-of select='$user-name'/> &lt;<xsl:value-of select='$user-login'/>&gt;</xsl:with-param>
  <xsl:with-param name='subject'>new institution</xsl:with-param>
  <xsl:with-param name='content'>

name: <xsl:value-of select='$institution/name'/>
<xsl:if test='$institution/name-english'>
name-english: <xsl:value-of select='$institution/name-english'/>
</xsl:if>
<xsl:if test='$institution/location'>
location: <xsl:value-of select='$institution/location'/>
</xsl:if>
homepage: <xsl:value-of select='$institution/homepage'/>
<xsl:if test='$institution/email'>
email: <xsl:value-of select='$institution/email'/>
</xsl:if>
<xsl:if test='$institution/phone'>
phone: <xsl:value-of select='$institution/phone'/>
</xsl:if>
<xsl:if test='$institution/postal'>
postal: <xsl:value-of select='$institution/postal'/>
</xsl:if>
<xsl:if test='$institution/fax'>
fax: <xsl:value-of select='$institution/fax'/>
</xsl:if>
<xsl:if test='$institution/handle'>
handle: <xsl:value-of select='$institution/handle'/>
</xsl:if>
<xsl:if test='string-length( $institution/note/text() )'>
note: <xsl:value-of select='$institution/note'/>
</xsl:if>

Submitted by user: <xsl:value-of select='$user-name'/> &lt;<xsl:value-of select='$user-login'/>&gt;
while editing record <xsl:value-of select='$record-id'/>

Added to the record? <xsl:choose>
<xsl:when test='$institution/add-to-profile = "true"'>yes</xsl:when>
<xsl:otherwise>no</xsl:otherwise>
</xsl:choose>

<xsl:text>
</xsl:text>

</xsl:with-param>
</xsl:call-template>
</xsl:template>




</xsl:stylesheet>

