if test $perllib
then 
    perlparams="-I$homelib -I$perllib"
fi

echo "#!$perlbin $perlparams"
echo 
echo "use lib qw( $perllib $homelib );"
echo
echo 'my $homedir = ' "'$homedir';"
echo

cat - <<'the_script_end'

use strict;
use warnings;

use ACIS::Web;
use ACIS::Web::Session;
use ACIS::Web::LogOff;

my $acis = ACIS::Web-> new( home => $homedir );

my $sessions_dir = $homedir . '/sessions';


opendir SDIR, $sessions_dir;
my @list = readdir SDIR;
closedir SDIR;

my $counter_logoff = 0;
my $counter_close  = 0;

foreach ( @list ) {
  my $sfile = $sessions_dir . '/' . $_ ;

  next if not -f $sfile;

  my $session = ACIS::Web::Session::load ( $sfile );

  if ( not $session ) {
    $acis -> errlog( "cleanup: bad session file $sfile" );
  }

  if( $session -> not_yet_expired() ) { next; }

  if( $session -> type() eq 'user' ) {

    $acis -> log( "cleanup: going to log off session $_" );

    $acis -> session( $session ) ;
    $counter_logoff ++;
    
    ACIS::Web::LogOff::user_normal_logoff( $acis );  

  } else {

    if( $session -> very_old ) {
      $acis -> log( "cleanup: closing an old session $_" );

      ### XXX do we want to know why user didn't finish her
      ### registration?  Or at least, who was that user?  But who it
      ### was we will find through the logs.

      $session -> close;
      $counter_close ++;
    }
  }


  $acis -> clear_after_request();


}

if( $counter_logoff or $counter_close ) {
  $acis -> log( "cleanup: logged-off: $counter_logoff; closed: $counter_close" );
}

the_script_end

