#  testing ARDB::Relations module

use Test ;

BEGIN { plan tests => 19; }

use strict;

eval ' use ARDB::Relations; ';

if ( $@ ) {  die $@;  } 

ok( not $@ );

my $sql;

###  create the object
use sql_helper;
sql_helper -> set_log_filename ( 'sql_helper.log' );

$sql = sql_helper->new('test', 'root' , 'root');

###  check the object
ok ($sql);

###  create relations object
my $table_name = 'test_relations';

my $relations  = new ARDB::Relations ($sql, $table_name);

ok ($relations);

###  create relations' table
ok ($relations -> create_table);

###  store
ok ( $relations -> store ( ['a', 'b', 'c', 'd'] ) );
ok ( $relations -> store ( ['a', 'b', '3', 'd'] ) );
ok ( $relations -> store ( ['1', '2', '3', '4'] ) );
ok ( $relations -> store ( ['8', '2', '3', 'pi'] ) );
ok ( $relations -> store ( ['$', '%', '^', '&'] ) );


###  fetch
my @res = $relations -> fetch ( [undef, undef, undef, 'd'] );

use Data::Dumper;
print Dumper (\@res);

ok ( scalar @res == 2    );
ok ( $res[0]->[0] eq 'a' );
ok ( $res[0]->[1] eq 'b' );
ok ( $res[0]->[2] eq 'c' );
ok ( $res[0]->[3] eq 'd' );

@res = $relations -> fetch ( [undef, '2', undef, 'd']    );
ok ( scalar @res == 0 );

@res = $relations -> fetch ( [undef, '2', '3', undef ]   );
ok ( scalar @res == 2 );

@res = $relations -> fetch ( [undef, undef, '3', undef ] );
ok ( scalar @res == 3 );


###  remove
my $sql_res = $relations -> remove (['a']);

# print "delete: " , Dumper ( $sql_res );
ok( $sql_res == 2 );

$sql_res = $relations -> fetch ();

print Dumper ($sql_res);


###  delete
ok ( $relations -> delete_table () );




