use strict;
use Test;

BEGIN { plan tests => 24 }

use ACIS::Data::DumpXML qw(dump_xml);
use ACIS::Data::DumpXML::Parser;

# added for view XML in MSIE 6.0
# $Data::DumpXML::DTD_LOCATION = '';

#my $a = undef;
#$b = \$a;
#die ref $b;

my $filename = "./test-dump.xml";

my $str = 'bla-bla';

my $array_ref = [ $str, 'nif, naf, nuf' ];

my $object =
 {
  'str'   => $str,
  'undef' => undef,
  'empty-array' => [],
  'array' => $array_ref,
  'hash'  =>
   {
    'key'        => 'value',
    'empty-hash' => {},
    'ref'        => \$str,
    'ref-ref'    => \\$str,
   },
#  'object' => new CGI,
 };

$object -> {'hash'} -> {'array-ref'} =
 $object -> {'array'};

bless $object -> {hash}, 'dummyobject';

my $dumped = dump_xml ($object);

open  DUMPED, "> $filename-dumped";
print DUMPED $dumped;
close DUMPED;

ok $dumped =~ /key=("|')str("|')[^>]*>\Q$str<\//;

ok $dumped =~ /key=("|')undef("|')[^>]*><undef\s*\/><\//;

ok $dumped =~ /key=("|')empty-array("|')[^>]*>\s*<empty-array\s*\/>\s*<\//s;

ok $dumped =~ /id=("|')1("|')\s*key=("|')array("|')[^>]*>[\s\n\r]*<list-item/s;

ok $dumped =~ /class=("|')dummyobject("|')\s*key=("|')hash("|')[^>]*>[\s\n\r]*</s;

ok $dumped =~ /key=("|')key("|')[^>]*>value<\//s;

ok $dumped =~ /key=("|')empty-hash("|')[^>]*>\s*<empty-hash\s*\/>\s*<\//s;

ok $dumped =~ /key=("|')ref("|')[^>]*>\s*<reference>\Q$str<\//s;

ok $dumped =~ /key=("|')ref-ref("|')[^>]*>\s*<reference>\s*<reference>\Q$str<\//s;

ok $dumped =~ /key=("|')array-ref("|')[^>]*>\s*<reference\s*to=("|')1("|')\/>\s*<\//s;

my $parsed = ACIS::Data::DumpXML::Parser -> new -> parsefile ("$filename-dumped");

use Data::Dumper;

print Dumper $object;
print Dumper $parsed;

ok $parsed;

ok ref $parsed eq 'HASH';

ok $parsed -> {'str'} eq $str;

ok not defined ($parsed -> {'undef'});

ok not scalar @{$parsed -> {'empty-array'}};

ok scalar @{$parsed -> {'array'}} eq 2;

ok $parsed -> {'array'} -> [1] eq 'nif, naf, nuf';

ok $parsed -> {'hash'} -> {'key'} eq 'value';

ok not scalar keys %{$parsed -> {'hash'} -> {'empty-hash'}};

ok ${$parsed -> {'hash'} -> {'ref'}} eq $str;

ok ${${$parsed -> {'hash'} -> {'ref-ref'}}} eq $str;

ok $parsed -> {'hash'} -> {'array-ref'} eq $parsed -> {'array'};

ok ref $parsed -> {hash} eq 'dummyobject';

my $dumped_from_parsed = dump_xml ($parsed);

open RESTORED, "> $filename-restored";
print RESTORED $dumped_from_parsed;
close RESTORED;

ok -s "$filename-dumped" == -s "$filename-restored";
