package sql_result;

use DBI;

use strict;


sub new {
    my $class = shift;
    my $statement = shift;

    my $self = {
	sth => $statement, 
	error => $statement -> errstr(),
	rows => $statement -> rows(),
    };

    bless $self, $class;

    if( $self->{'rows'} ) {
	$self-> next();
    }

    return $self;
}


sub next {
    my $self = shift;
    my $st = $self->{'sth'};
    my $row = $st -> fetchrow_hashref();
    $self -> {row} = $row;
    return $row;
}


sub get {
    my $self = shift;
    my $field = shift;

    my $row = $self->{'row'};
    return $row->{$field};
}


1;
__END__


###############################################################################
#            S Q L    C O N N E C T 
###############################################################################

sub sql_connect {

    my $database = shift;
    my $user = shift;
    my $pass = shift;
    my $host = shift;
    my $port = shift;

    my $connect_string = "DBI:$driver:$database";

    if( $CONNECTED ) {
	$DB_H -> disconnect();
	$CONNECTED = 0;
    }

    if( defined $host ) {
	$connect_string .= ":$host";
	if( defined $port ) {
	    $connect_string .= ":$port";
	}
    }

    $DB_H = DBI -> connect( $connect_string, $user, $pass,
			    {'RaiseError'=>0,
			     'PrintError'=>1} );

    if ( not $DB_H ) {
	$CONNECTED = 0;
	put_to_log ( "Failed attempt to connect to a server" );

    } else {
	$CONNECTED = 1;
	put_to_log ( "Connected to a server" );
    }

    return $CONNECTED;
}



END {
    foreach my $sth ( values %STATEMENTS ) {
	if( $sth->{Active} ) {
	    $sth->finish;
	}
    }
    if( $CONNECTED ) {
	$DB_H -> disconnect();
	put_to_log ( "Disconnected from a server" );
	$CONNECTED = 0;
    }
}


###############################################################################
#       Q U O T E 
###############################################################################

sub quote {
    return $DB_H -> quote ( shift );
}




###############################################################################
#             S Q L    S E T    L O G    F I L E N A M E 
###############################################################################

sub sql_set_log_filename {
    my $name = shift;
    $LOG = $name;
}


###############################################################################
#             P U T    T O    L O G    
###############################################################################


sub put_to_log {
    if( $LOG ) {
	open LOG, ">>$LOG" || die "Can't open SQL log: $LOG";
	print LOG scalar( localtime (time) ) , " ", @_, "\n";
	close LOG;
    } else {
	print STDERR scalar( localtime (time) ) , " ", @_, "\n";
    }
}





###############################################################################
#             S Q L    Q U E R Y    E X E C U T E 
###############################################################################
sub sql_query_execute {

    my $q = shift || die;
    my $descr = shift;

    my @params = @_;

    my $sth;

    if( exists $STATEMENTS{$q} ) {
	if( defined $STATEMENTS{$q} ) {
	    $sth = $STATEMENTS{$q};

	} else {
	    put_to_log( "Bad query ($descr) execution has been requested" );
	    return undef;
	}

    } else {
	if ( not $sth = $DB_H -> prepare( $q ) ) {
	    $ERROR = $DB_H -> errstr;
	    put_to_log( "Query: '$q' ($descr) is bad: '$ERROR'" );
	    $STATEMENTS{$q} = undef;
	    return undef;
	} 
	put_to_log( "Query: '$q' ($descr) has been successfully prepared" );
	$STATEMENTS{$q} = $sth;
    }

    my $res ;

    if ( not $res = $sth -> execute( @_ ) ) {
	$ERROR = $DB_H -> errstr;
	put_to_log( "Query: $descr failed: '$ERROR'" );
	return undef;
    }

    put_to_log( "Execute: $descr - OK ($res)" );
    return ( $sth, $res );
}

###############################################################################
#                S Q L    Q U E R Y 
###############################################################################

sub sql_query {
    my $q = shift || die "give query string";
    my $d = shift || die "give query description to the sql_query()";

    my ($sth, $res ) = sql_query_execute( $q, $d, @_ );

    my @result = ();

    if( not defined $sth ) {
	return undef;
    } 
    if( not $sth -> rows ) { 
#	$sth -> finish;
	return []; 
    }

    my $rows = $sth -> rows;
    
    my $i = 0;
    while ( $i < $rows ) {
	my @array = $sth -> fetchrow_array;
	push @result, \@array;

# debug:
#	print "ROW: [ " , join ( ', ' , @array ) , " ]\n" ;

	$i++;
    }

#    $sth->finish;
    return \@result;
}



###############################################################################
#                S Q L    Q U E R Y    --   S C A L A R    R E S U L T 
###############################################################################

sub sql_query_scalar_result {
    my $q = shift || die;
    my $d = shift || die;

    my ($sth, $res ) = sql_query_execute( $q, $d, @_ );

    my @result = ();

    if( not defined $sth ) {
	return undef;
    } 
    if( not $sth -> rows ) { 
#	$sth -> finish;
	return undef; 
    }

    my $rows = $sth -> rows;
    
    if ( $rows > 1 ) {
	### strange, because normally you would 
	die "scalar result query returned a table instead";
    }
    
    my @array = $sth -> fetchrow_array;
    if( scalar @array > 1 ) {
	### strange
	die "scalar result query returned a multiple-value row instead";
    }

#    $sth->finish;
    return $array[0];
}


###############################################################################
#                S Q L    D O    S T A T E M E N T  
###############################################################################

sub sql_do_direct {
    my $q = shift || die;
    my $d = shift || die ;

    my $r; 
    eval {
	$r = $DB_H -> do ( $q, undef, @_ ) ;
    } ;
    $ERROR = $DB_H -> errstr;
    if( $ERROR ) {
	put_to_log( "Statement: '$q' ($d) failed: '$ERROR'" );
	return undef;

    } else {
	put_to_log( "SQL: $d - OK" );
	return $r;
    }
}


sub sql_do {
    my $q = shift || die;
    my $d = shift || die ;

    my ($sth, $r) = sql_query_execute( $q, $d, @_ );

    return $r;
}



###############################################################################
#   L I S T    T A B L E S 
###############################################################################
sub list_tables {
    return $DB_H -> tables();
}

###############################################################################
#   G E T    T A B L E    I N F O  
###############################################################################
sub get_table_info {

    my $tname = shift;
    my @tables = $DB_H -> tables();
    foreach my $t ( @tables )  {
#	print "table $t exists...";
	if( $t eq $tname ) {
#	    print "that's what we need!\n";
	    return sql_query( "DESCRIBE $tname", "getting details of table $tname" );
	}
#	print "\n";
    }
    return undef;
}


###############################################################################
#   MYSQL LAST INSERT ID
###############################################################################
sub mysql_last_insert_id {
    return $DB_H->{'mysql_insertid'};
}

###############################################################################
#
###############################################################################
###############################################################################
#
###############################################################################
###############################################################################
#
###############################################################################
###############################################################################
#
###############################################################################



###############################################################################
###############################################################################
###############################################################################
###############################################################################
###############################################################################
###############################################################################








1;

