#!/usr/bin/perl

use Test;
use strict;

BEGIN { plan tests => 4 ; }

$ARDB::DEBUG = 1;


# ARDB  ࠧ  ᪮쪮 ᪨ ⥩   । ஢
# 㭪樮쭮.

#ࢠ  - 䨣樨  ⮢  ࠡ.
#   ARDB ࠭  ६ local_path  ARDB::LocalConfig
#ࠬ 㯠    ࠭  ARDB::SiteConfig
#ࠬ ࠡ ARDB ࠭  ४ਨ  ARDB,  䠩, 㪠 
#ARDB::SiteConfig

#  - ஢ઠ ࠡᯮᮡ.
#ந ⪨

print "ARDB installation test\n";

print "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-";
print "\ntry using ARDB::Prepare...\n";

use ARDB::Prepare;

print "created database tables";

print "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-";
print "\ntry using ARDB::LocalConfig...\n";

###################### ARDB data directory ########################

use ARDB::LocalConfig;

ok ($ARDB::LocalConfig::local_path);

print "ARDB data directory: ", $ARDB::LocalConfig::local_path, "\n";

################## ARDB params configuration ######################
print "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-";
print "\ntry using ARDB::SiteConfig...\n";

use ARDB::SiteConfig;

my $site_config = new ARDB::SiteConfig;

ok ( $site_config );

print "these variables are defined in ardb parameters configuration:\n";

foreach ( @ARDB::SiteConfig::parameters )
 {
  print $_, " - '", $site_config -> $_, "'\n";
 }

################## ARDB::Configuration  #################

print "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-";
print "\ntry using ARDB::Configuration...\n";

use ARDB::Configuration;

my $config_file = $ARDB::LocalConfig::local_path . '/' . $site_config -> config_file;
$config_file =~ s/\/\//\//;

print "try parsing system configuration from '$config_file'\n";

my $config = new ARDB::Configuration ( $config_file );

ok ( $config );

print "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-";
print "\ntry using ARDB...\n";

use ARDB;

my $ardb = new ARDB;

ok ( $ardb );

