package RePEc::Index::Collection::ACIS_UD;

use strict;
use base 'RePEc::Index::Collection';
use vars '$POSITION';

use ACIS::Data::DumpXML::Parser;
use ACIS::Common;

use ACIS::UserData::User::Record;
use ACIS::UserData::Data::Record;

use Data::Dumper;

use Digest::MD5 'md5_hex';

$ACIS::DEBUG = 'on';
$ACIS::DEBUGIMMEDIATELY = 'on';

$POSITION = -1;

sub open_data_file
 {
  my $self = shift;
  my $file = shift;
  
  $POSITION = -1;
  
  debug 'try open file';
  
  eval
   { $self -> {'data'}  =
    ACIS::Data::DumpXML::Parser -> new -> parsefile ( $file ); };
  
  if ($@)
   {
    debug "errors: $@";
    return undef;
   }
  
  $self -> {'filename'} = $file;
  debug 'all ok';
  
  return 'true';
 }

sub get_next_record
 {
  my $self = shift;
  
  my $data;
  my $checksum;
  
  debug 'try get record';
  
  if ($POSITION < 0)
   {
    debug 'waiting for user-data owner: data, checksum, ARDB::Record interface';
    $data  = $self -> {'data'} -> {'owner'};
    
    return 0
     unless defined $data;
    
    $checksum = md5_hex(Dumper $data);
    
    bless  $data, 'ACIS::UserData::User::Record';
    debug 'received';
   }
  else
   {
    debug 'waiting for user-data record: data, checksum, ARDB::Record interface';
    $data  = $self -> {'data'} -> {'records'} -> [$POSITION];
    
    unless (defined $data)
     {
      debug 'previous record are last...';
      return 0;
     }
    
    $checksum = md5_hex (Dumper $data);
    $data -> {'LOGIN'} = $self -> {'data'} -> {'owner'} -> {'login'};
    
    bless  $data, 'ACIS::UserData::Data::Record';
    debug 'received';
   }
  
  $data -> {'FILENAME'} = $self -> {'filename'}; 
  $POSITION++;
   
  return ($data -> id, $data, $data -> type, 0, $checksum); 
 }
 
sub check_id
 {
  return 1;
 }
 
1;