package ARDB::SiteConfig;

use strict;
use Carp::Assert;
use AppConfig qw(:expand);


use ARDB::Common;

use vars qw(  @parameters $AUTOLOAD );

@parameters = qw( db_port db_host db_user db_pass db_name daemon_socket );


sub AUTOLOAD
 {
  my $self = shift;
  my $routine = $AUTOLOAD;
  substr( $routine, 0, length( __PACKAGE__ ) + 2 )= ''; 
  return $self->{$routine};
 }

sub new
 {
  my $class = shift;

  my $home  = shift;
  assert( $home );
 
  my $self = {};

  # read the file
 
  # create a new AppConfig object
  my $filename = $home . '/site_config';

  $filename =~ s|//|/|g;

  if ( not -e $filename 
       or not -r _ ) {
    critical "Local site configuration file doesn't exist";
  }

  debug "creating AppConfig object";
  my $config = new AppConfig
    ( 
     {
      GLOBAL  => 
      {
       ARGCOUNT => 1,
       DEFAULT  => "",
      },
      ERROR     => \&critical 
     },
     @parameters
    );


  $config -> file ( $filename );

  # go through the @parameters, requesting the values from the file
  # and storing them into $self hash
  
  foreach my $param ( @parameters )
   {
    $self -> { $param } = $config -> get ( $param );
   }

  bless $self, $class;

  return $self;

 }

1;

=pod

=head1 name

ARDB::SiteConfig - module provides local configuration, such as database params

=head1 synopsis

use ARDB::SiteConfig;

my $site_config = new SiteConfig;

my $db_name = $site_config -> db_name;
# or
$db_name = $site_config -> {db_name};

=cut
