package ACIS::Web::Session;

use strict;

use Data::Dumper;
use Carp::Assert;

use ACIS::Common;

use ACIS::Data::DumpXML qw(dump_xml);

use Storable;

sub current_record
 {
  my $self = shift;
  
  my $userdata = $self->{'user-data'};

  if 
   (defined $userdata
    and defined $userdata -> {'records'}
    and scalar @{ $userdata -> {'records'} } )
   {
    my $rec_no = $self -> {'current-record-number'} || 0 ;
    
    $self -> {'current-record-number'} = $rec_no;
    
    my $shared = $self -> {'.paths'} -> {'shared'};
    my $static = $self -> {'.paths'} -> {'static'};
    my $record = $userdata -> {'records'} -> [$rec_no];
    my $sid    = $record -> {'short-id'};
    
    unless (defined $self -> {'.paths'} -> {'user-page'})
     {
      $self -> {'.paths'} -> {'personal-path'}  = "$shared/$sid.",
      $self -> {'.paths'} -> {'personal-url'}   = "$static/$sid.",
     }
     
#    debug "self->user-data [$rec_no]: ". Dumper $self->{'user-data'};

    return $userdata -> {'records'} -> [$rec_no];
   }
  die;
   
 }


### iku's experiments

sub load
 {
  my $acis = shift;
  my $sid  = shift;
  my $self;
  
  my $paths  = $acis -> paths;

  my $home   = $paths -> {home};
  my $sessions_dir = "$home/sessions";

  my $filename     = "$sessions_dir/$sid";
  
  if (not -f $filename)
   {
    return undef;
   }

  my $Mtime = -M $filename;

  debug 'session time difference: ' . ( $Mtime*24*60 ) . ' minutes';
  
  if ( $Mtime * 72 > 1 )
   {
    if ( not $ACIS::DEBUG )
     {
      ### XXX
      return undef;
     }
   }    
  
  eval { $self = retrieve ($filename); };
  
  if ($@)
   {
    debug "loading a session failed: $@";
    return undef;
   }

#  $self -> {'paths'} = $paths;

  ### XXX: need to respect acis settings 
  bless $self;
  
  debug 'all ok';
  $self -> {'.paths'} = $acis -> {'paths'};
  
  return $self;
 }



sub create_new
 {
  my $app = shift;
  my $owner = shift;
  my $type  = shift;

  assert( ref $app );
  assert( not $app -> session );

  my $paths  = $app -> paths;

  my $home   = $paths -> {home};
  my $sessions_dir = "$home/sessions";

  assert ( -w $sessions_dir ) ;

  my $sid = 0;

  debug "generate session-id";
  
  while (! $sid)
   {
    $sid = &generate_id;
    
    debug "generated '$sid' id";

    my $filename = "$sessions_dir/$sid";

    $sid = 0 if (-f $filename);
    
    if ($sid and open SESSION, "> $filename")
     {
      print SESSION 'new session';
      close SESSION;
      
      debug "session '$filename' created";
      
      $app -> {'paths'} -> {'session'} = $filename;
      
      my $self = 
       {
        '.id' => $sid,
        '.owner' => $owner,
        '.file'  => $filename,
        '.paths' => $app -> {'paths'},
       };
 
      if ($type)
       {
        $self -> {'.type'} = $type;
       }
      
      bless $self;
      
      return $self;
     }
   }
 }


sub id
 { 
  my $self = shift;
  return $self->{'.id'};
 }

sub type
 { 
  my $self = shift;
  return $self->{'.type'};
 }


sub owner
 { 
  my $self = shift;
  return $self->{'.owner'};
 }


sub save 
 {
  my $self     = shift;
  my $filename = $self -> {'.file'};
  store $self, $filename;
 }
 



###############   t h r o w   a w a y   ###########################


sub old_new
 {
  my $class = shift;
  my $paths  = shift;
  
  my $self =
   {
    'paths' => $paths,
   };
  
  bless  $self, $class;
  return $self;
 }



sub old_save
 {
  my $self = shift;
  
  my $session = $self -> {'paths'} -> {'session'}; 
  
  store $self, $session;
 }


sub old_load
 {
  my $self_ref = \$_[0]; shift;
  my $sid  = shift;
  
  my $paths = $$self_ref -> {'paths'};
  
  my $file_name = $paths -> {'session'};
  
  return "session '$file_name' not found"
   unless -f $file_name;
  
  debug 'session time difference: ' . (-M $file_name)*24*60*60 . ' seconds';
  
  unless ($Web::DEBUG)
   {
    return "saved session expires"
     if ((-M $file_name)*72 > 1);
   }
  
  my $loaded = retrieve ($file_name);
  
  $$self_ref = $loaded;
  $$self_ref -> {'paths'} = $paths;
  
 }




sub old_create
 {
  my $self = shift;
  my $sid  = shift;
  
  unless (defined $sid)
   {{
    debug "generate session-id";
    
    $sid = &generate_id;
    
    debug "generated '$sid' id";
    
    my $file_name = $self -> {'paths'} -> {'home'} . "/sessions/$sid";
    
    if (-f $file_name)
     {
      debug "file found, try timestamp";
      
      next
       if ((-M $file_name)*72 > 1);
     }
    
    debug 'try create file';
    
    if (open SESSION, "> $file_name")
     {
      print SESSION 'new session';
      
      close SESSION;
      
      debug "session '$file_name' created";
      
      my $home = $self -> {'paths'} -> {'home'};
      
      $self -> {'paths'} -> {'session'} = "$home/sessions/$sid";
      $self -> {'paths'} -> {'unconfirmed'} = "$home/unconfirmed/$sid.xml";
      
      return $sid;
     }
    
    debug "cannot access file";
    
    next;
   }}
 }








 
1;
