package ACIS::Web;

#   Continuing ACIS::Web class, although this is already another file
#   (ACIS::Web::Services)

use strict;
use Data::Dumper;
use Carp::Assert;

use ACIS::Common;
use ACIS::Data::DumpXML qw(dump_xml);
use ACIS::Web;

####   SESSION STUFF   ####

sub create_session
 {
  my $app = shift;

  my $session = ACIS::Web::Session::create_new ($app, @_);

  $app -> {'session'} = $session;
  
  $app -> {'presenter-data'} -> {'request'} -> {'session'} = 
   {
    'id'              => $session -> id,
    'type'            => $session -> type,
#    'current-record'  => 
#     {
#      'id'   => $session -> current_record -> {'id'},
#      'name' => $session -> current_record -> {'full-name'},
#      'type' => $session -> current_record -> {'type'},
#     },
   };
  
  $app -> {'presenter-data'} -> {'request'} -> {'user'} =
   $session -> {'owner'};
    
  return $session;
 }



sub load_session
 {

  my $app = shift;
  
  my $request  = $app -> request;
  my $home     = $app -> {'home'};
  
  my $sid      = $request -> {'session-id'};

  if( not $sid )
   {
    $app -> clear_process_queue;
    return undef;
   }

  my $IP       = $ENV{'REMOTE_ADDR'};
  
  my $session = ACIS::Web::Session::load ( $app, $sid );

  if ( not $session )
   {
    $app -> error( "session-failure" );
    $app -> clear_process_queue;
    # XXX
    debug "can't load the session, ACIS::Web::Session::_load failed";

    return undef;
   }


  if ( $session -> owner -> {IP} eq $IP )
   {
    debug "previous session found, IP matches, continuing";
    
    use Data::Dumper;
    
    my $dump = Dumper( $session );
    
    #	die "Session is <$dump>...";
    debug "session is like this <$dump>";


    ### XXX
    ### expiration check belongs here. I mean:
    ### has this session expired?

    ### we can more-or-less safely forget about it, as long we run
    ### session-collection script, which will close and delete old
    ### sessions.  And this script is another XXX.
   }
   
  else 
   {
    # IPs don't match -- should not continue
    $app -> error( "session-failure" );
    $app -> clear_process_queue;
    debug "can't load the session, IP addresses don't match";

    # XXX
    return undef;
   }

  $app -> {session} = $session;
  $app -> {'presenter-data'} -> {'request'} -> {'session'} = 
   {
    'id'              => $session -> id,
    'type'            => $session -> type,
    'current-record'  => 
     {
      'id'   => $session -> current_record -> {'id'},
      'name' => $session -> current_record -> {'full-name'},
      'type' => $session -> current_record -> {'type'},
     },
   };
  
  $app -> {'presenter-data'} -> {'request'} -> {'user'} =
   $session -> {'owner'};

  return $session;
 }

####  END OF SESSION STUFF  ####


####  A U T H E N T I C A T I O N    ####

sub authenticate
 {
  my $app = shift;

  ### if a session is already loaded, why authenticate?

  return undef if $app -> session;

  ### some preparations
  my $request  = $app -> request;
  my $home     = $app -> {home};
  my $vars     = $app -> variables;

  my $login;  # that is what we need to find out
  my $passwd;

  debug "check CGI parameters and cookies";
  
  # now we find out

  my $query        = $request -> {'CGI'};
  my $query_params = scalar $query -> param;
 
  $login  = $query -> param( 'login' ); 
  $passwd = $query -> param( 'pass' );
 
  if ( not defined $login )
   {
    $login = $query -> cookie ( 'login' );

    if( not defined $passwd )
     {
      $passwd = $query -> cookie( 'pass' );
     }
   }

  # final check
  if (not defined $login
       or not defined $passwd)
   {

    $app -> clear_process_queue;

    if( defined $login )
     { $vars -> {login} = $login; }
     
    $app -> set_presenter ('login');

    return undef;
   }
  
  debug "we do have both login ($login) and password ($passwd)";
  
  ###  now it's time to check, if such a user exists and if her
  ###  password matches to the one entered.
  ###  if both true, check the lock;
  ###  if no lock, load userdata into $app

  my $udata;

  my $udata_file;
  my $udata_lock;
  my $udata_deleted;

  my $word_login = $login;
  $word_login =~ s/\W//g;
    
  my $fl = substr ($word_login, 0, 1);
  my $sl = substr ($word_login, 1, 1);
    
  $udata_file    = "$home/userdata/$fl/$sl/$login.xml";
  $udata_lock    = "$home/userdata/$fl/$sl/$login.lock";
  $udata_deleted = "$home/deleted-userdata/$fl/$sl/$login.xml";


  if( not -f $udata_file )
   {
    # no such user 
    $app -> error ( 'login-unknown-user' );

    $app -> clear_process_queue;
    $app -> set_presenter ( 'index' );
    return undef;
   }

  debug "going to load user-data to check password";

  $udata = load ACIS::Web::UserData ( $udata_file );

  if( not defined $udata )
   {
    $app -> error( 'login-account-damaged' );
    $app -> clear_process_queue;
    $app -> set_presenter ('sorry');
    return undef;
   }

########################### vano: really?#######################
#  assert( $udata );
#
#  assert( $udata -> {'owner'} -> {'login'}    );
#  assert( $udata -> {'owner'} -> {'password'} );
#  
#  assert( $login eq $udata -> {'owner'} -> {'login'} );
################################################################

  if ( $passwd ne $udata -> {'owner'} -> {'password'} )
   {
    $vars -> {login} = $login;
    $app -> error( 'login-bad-password' );
    $app -> clear_process_queue;
    $app -> set_presenter ('login');
    return undef;
   }

  debug "password match, now check user-data lock";
 
  my $lock = $udata_lock;
  
  if ( -f $lock and open LOCK, $lock)
   {{
    debug "found lock file at '$lock'";
      
    $lock = <LOCK>;
    close LOCK;

    ### go get the session, if it exists
    ### ignore the lock if it doesn't
    ### if it exists, see if user wants to steal it...
    
    last unless -f "$home/sessions/$lock";
    
    my $session = ACIS::Web::Session::load ($app, $lock);
      
    unless (defined $session or $session or ref $session eq 'HASH')
     {
      unlink $lock;
      debug "but session doesn't exist anymore";
      last;
     }
    
    debug "and in fact, there is a session, and it belongs to the user";
    
    ### XXX  
    ### steal it?
    ### because we could
    
    last if $ACIS::DEBUG;
    
    my $owner = $session -> owner;

    $vars -> {'locked-by'} = $owner;

    $app -> error( 'login-account-locked' );
    $app -> clear_process_queue;
    $app -> set_presenter ('sorry');
    return undef;
     
   }}
  else
   {
    debug 'lock file not found';
   } 
   
  ### update $app with just loaded user data
  
  $app -> { 'user-data' } = $udata;
    
  ### now need to create a session
  
  my $owner = $udata -> {owner};

  $owner -> {'IP'} = $ENV {'REMOTE_ADDR'};

  my $session = $app -> create_session ( $owner, "user" );
  
  my $sid = $session -> id;
  
  debug "new session created: $sid";
  
  if (open LOCK, "> $udata_lock")
   {
    print LOCK $sid;
    close LOCK;
    debug "lock created";
   }
  
  ### make a copy of userdata in session

  $session -> {'user-data'} = $udata;

  my $auto_login = $query -> param ('auto-login');
  
  if ($auto_login)
   {
    print "Set-Cookie: login=$login; path=/\n";
    print "Set-Cookie: pass=$passwd; path=/\n";
    debug "cookie set";
   } 

  ### redirect to the same screen, but with session id

  my $base_url = $app -> {config} -> {'base-url'};
  my $screen   = $app -> {request} -> {screen};

  my $URI = "$base_url/$screen!$sid";

  debug "requesting a redirect to $URI";
  
  $app -> clear_process_queue;
  $app -> redirect( $URI );
  
  my $paths =
   {
    'user-data'   => $udata_file,
    'lock'        => $udata_lock,
    'deleted-user-data' => $udata_deleted,
   };
  
  %{ $app -> {'paths'} } = 
    ( %{$app -> {'paths'}}, %$paths );
  
  return $udata;

 }



sub load_session_or_authenticate
 {
  my $app = shift;
  
  my $processors = [];
  foreach (@{$app -> {'processors'}})
   {
    push @$processors, $_;
   }
   
  my $session = $app -> load_session;
  $app -> {'processors'} = $processors
   unless defined $session;
   
  my $udata = $app -> authenticate;
  return $udata;
 }



# created by iku:
#   I was thinking about a special screen, which would 
#   show us contents of the session.  This could help 
#   us debug things.

sub show_session {
  my $acis = shift;
#  use Data::Dumper;
#  my $dump = Dumper( $session );
}

##############################################################
###################### EMAIL SENDING #########################
##############################################################

sub send_mail
 {
  my $self = shift;
  my $stylesheet = shift;
  
  debug "sending email with template '$stylesheet'";
  
  my $data = 
   {
    'config'    => {},
    'paths'     => $self -> paths,
    'session'   => $self -> session,
#    'user-data' => $self -> user_data,
    'variables' => $self -> {'presenter-data'},
   };
  
  foreach (keys %{$self -> config})
   {
    next if $_ eq 'screens';
    $data -> {'config'} -> {$_} = $self -> config -> {$_};
   }

  my $content = dump_xml ($data);
  debug $content;
  
  my $config  = $self -> config;
  
  my $presenter = $self -> paths -> {'presenters'} . '/' . $stylesheet;

  my $message = ACIS::Web::launch_presenter( 'xslt', $content, $presenter );
  debug "[email] $message";

  
  my $sendmail = $config -> {'sendmail'};
  
  unless (defined $sendmail and $sendmail)
   {
    debug "can't send e-mail message, because no sendmail path defined";
    return;
   }

  
  open MESSAGE, "> $sendmail";
  print MESSAGE $message;
  close MESSAGE;
 }

##########################################################
############### FORM PROCESSING STUFF ####################
##########################################################

sub form_invalid_value
 {
  form_error ($_[1], 'invalid-value', $_[2]);
 }

sub form_required_absent
 {
  form_error ($_[1], 'required-absent', $_[2]);
 }

sub form_error
 {
  my $self    = shift;
  my $place   = shift;
  my $element = shift;
  
  unless
   (ref $self -> {'presenter-data'} -> {'response'} ->
    {'form'} -> {'errors'} -> {$place} eq 'ARRAY')
   {
    $self -> {'presenter-data'} -> {'response'} ->
    {'form'} -> {'errors'} -> {$place} = [];
   }
  push @{$self -> {'presenter-data'} -> {'response'} ->
   {'form'} -> {'errors'} -> {$place}}, $element;
 }

sub set_form_value
 {
  my $self    = shift;
  my $element = shift;
  my $value   = shift;
  
  $self -> {'presenter-data'} -> {'response'} ->
   {'form'} -> {'values'} -> {$element} = $value;
 }

sub get_form_value
 {
  my $self    = shift;
  my $element = shift;

  return $self -> {'presenter-data'} -> {'request'} ->
   {'form'} -> {'input'} -> {$element};
 }



sub path_to_val
 {
  my $data  = shift;
  my $path  = shift;
  
  my @path  = split '/', $path;
  foreach (@path)
   {
    $data = $data -> {$_};
   }
  return $data;
 }

sub assign_path
 {
  my $data  = shift;
  my $path  = shift;
  my $value = shift;

  assert( $data );
  assert( $path );
#  assert( $value );

  my @path = split '/', $path;
  my $last = pop @path;
  foreach (@path)
   {
    unless (defined $data -> {$_})
     { $data -> {$_} = {}; }
    
    $data = $data -> {$_};
     
   }
  $data -> {$last} = $value;
 }

sub prepare_form_data
 {
  my $self   = shift;
  
  my $screen       = $self -> request -> {'screen'};
  my $screen_data  = $self -> config -> screen ($screen);
  my $params       = $screen_data -> {'variables'};
  my $session_data = $self -> {'session'} -> {'user-data'};
  
#  my $form_values  = $self -> {'presenter-data'} -> {'request'} ->
#   {'form'} -> {'input'};
  
  foreach (@$params)
   {
    next unless defined $_ -> {'place'};
      
    my $data;
      
    my @places = split ',', $_ -> {'place'};
      
    foreach my $place (@places)
     {
      my ($prefix, $place) = split ':', $place;
        
      if ($prefix eq 'owner')
       { $data = $self -> session -> {'user-data'} -> {'owner'}; }

#      elsif ($prefix eq 'user')  ### XXX this one is outdated
#       { $data = $self -> session -> {'user-data'} -> {'user'}; }

      else { $data = $self -> session -> current_record; }
      
      $self -> set_form_value ($_ -> {'name'}, path_to_val ($data, $place));
     }  
   }
 }

sub process_form_data
 {
  my $self = shift;
  
  my $screen = $self -> request -> {'screen'};
  my $screen_data = $self -> config -> screen ($screen);
  my $params = $screen_data -> {'variables'};
  
  foreach my $par (@$params)
   {
    my $name = $par->{name};
    debug "apply parameter name = '" . $name . "', value = '" . 
      $self -> variables -> {'verified'} -> {$name} . "'";
     
    next unless defined $par -> {'place'};
     
    debug 'proceed...';
      
    my $data;
      
    my @places = split ',', $par -> {'place'};
      
    foreach my $to (@places)
     {
      my ($prefix, $place) = split ':', $to;

      if ( $prefix eq 'user' )
       { $data = $self -> session -> {'user-data'} -> {user}; }
      
      elsif ( $prefix eq 'owner' )
       { $data = $self -> session -> {'user-data'} -> {owner}; }
      
      elsif ( $prefix eq 'record' )
       { $data = $self -> session -> current_record; }

      # else { die; } vano: really? ?

      assert (defined $data);
      assert (ref $data eq 'HASH');

      assign_path ($data, $place, pack('U*',
       unpack('U*', $self -> get_form_value ($name))));
      
     }  
   }
  #delete $self -> variables -> {'verified'};
 }

sub check_input_parameters
 {
  my $self   = shift;
  
  my $required_absent;
  my $invalid_value;
  my $screen = $self -> request -> {'screen'};
  my $screen_data = $self -> config -> screen ($screen);
  my $params = $screen_data -> {'variables'};

  my $vars   = $self -> variables;
  
  my $form_values  = $self -> {'presenter-data'} -> {'request'} ->
   {'form'} -> {'input'};
  
  my $cgi = $self -> {'request'} -> {'CGI'};
  my %cgi_vars = $cgi -> Vars;
  
  debug "loading CGI::Untaint";

  my $handler = new CGI::Untaint ({INCLUDE_PATH => 'ACIS/Web'}, %cgi_vars );
  
  debug "checking input parameters";
  
  foreach ( @$params )
   {
    my $type     = $_ -> {'type'};
    my $name     = $_ -> {'name'};
    my $required = $_ -> {'required'};
    
    next unless $type;
    
    my $value = undef;
    if (defined $form_values -> {$name} and $form_values -> {$name})
     {
      $value = $handler -> extract("-as_$type" => $name);

      my $v = $form_values -> {$name};
      
      $self -> set_form_value ($name, pack('U*',
       unpack('U*', $v ))) if $v;
     }
    
    unless (defined $value and $value)
     {

      if ($handler -> {_ERR})
       {
        debug "not passed, because invalid value at $name with type='$type', $handler->{_ERR}";
        
        form_error ($self, 'invalid-value', $name);
        $invalid_value = 'yes';
       }
      else
       {
        debug "undefined value at $name";
        
        if ($required)
         {
          form_error ($self, 'required-absent', $name);
          $required_absent = 'yes';
         }
       } 
     }
   }

  if ($required_absent or $invalid_value)
   {
    $self -> clear_process_queue;
   }
 }


1;
