package ACIS::Web::Handler::User;

use strict;
use warnings;

use Data::Dumper;

use CGI::Untaint;

use ACIS::Common;
use ACIS::Data::DumpXML qw(dump_xml);

use ACIS::Web::Handler::Affiliations;
use ACIS::Web::Handler::Main;

use Carp::Assert;


sub login
 {
  debug "running login user screen";
  
  my $self = shift;
  
#  $self -> redirect_to_screen ('welcome');
 }

sub welcome
 {
  debug "running initial user screen";
  
  my $self = shift;
  
  debug Dumper $self;
  
  $self -> variables -> {'form-data'} = $self -> session -> current_record;
  
#  my $current_user_data_i = ;
 }

#       $acis_web -> {entered-user-data}
#        ($acis_web -> {errors})  :
# [error-context, error-type]
#  ,       
# [screen-name/param-name, form-field/error-text]
#   mysql 
# [database, query-type/error-text]


sub personal_data_init
 {
  my $self = shift;
  
  $self -> set_form_value ('name-variations',
   join ("\n", @{$self -> session -> current_record -> {'name-variations'}}));
 }


sub personal_data
 {
  my $self = shift;
  
  debug "running personal data service screen";
  
  my $variations = $self -> get_form_value ('name-variations');
  $variations =~ s/[ ]+/ /gs;
  $variations = [split (/\s*[\n\r]+/, $variations)];
  
  $self -> session -> current_record -> {'name-variations'} = $variations;
   
  $self -> redirect_to_screen ('welcome');
 }


sub upload_photo
 {
  debug "upload photo screen";
  
  my $self = shift;
  
  my $session = $self -> session;
  my $request = $self -> request;
  my $record  = $session -> current_record;
  my $query   = $request -> {'CGI'};
  
  $CGI::POST_MAX = 2097152;  #;-)
  
  my $url  = $self -> paths -> {'personal-url'};
  my $path = $self -> paths -> {'personal-path'};
  
  if ($record -> {'photo'} and -f $path . $record -> {'photo'})
   {
    $self -> variables -> {'photo'} = $url . $record -> {'photo'};
   } 
  
  return unless $query -> param ('photo');
  
  my $file = $query -> upload('photo');
  if (!$file && $query -> cgi_error)
   {
    push @{$self -> variables -> {'errors'}}, 'photo-cgi-error'; #$query -> cgi_error;
    return;
   }
  
  my ($extension) = (sprintf ("%s", $file) =~ /^.*\.(.*)$/);
  
  debug "try to save file into '$path$extension'";
  
  if (open PHOTO,"> $path$extension")
   {
    binmode PHOTO;
    my $buffer;
    while (read ($file, $buffer, 1024))
     {
      print PHOTO $buffer;
     }
    close PHOTO;
   }
  else
   {
    push @{$self -> variables -> {'errors'}}, 'photo-cannot-open-file';
    return;
   } 
  $session-> current_record -> {'photo'} = $extension;
  
  $self -> redirect_to_screen ('welcome');
 }


sub sci_fields
 {
  debug "running sci-fields service screen";
  
  my $self = shift;
  
  $self -> redirect_to_screen ('welcome');
 }


sub affiliation_main
 {
  my $self = shift;
  
  my $search = $self -> session -> {'search'};
  $self -> variables -> {'search'} = $search
   if defined $search and ref( $search->{items} ) 
    and scalar @{$search -> {'items'}};
   
  my $affiliations = $self -> session -> current_record -> {'affiliations'};
  $self -> variables -> {'affiliations'} = $affiliations
   if defined $affiliations and scalar @$affiliations;
 }


sub affiliation_process
 {
  debug "running affiliation service screen";
  
  my $self   = shift;
  
  my $session = $self -> session;
  my $action = $self -> get_form_value ('action');
   
  if ($action eq 'continue')
   {
#      ACIS::Web::Handler::Affiliations::commit ($self);
    $self -> redirect_to_screen ('welcome');
   }
  else
   {
    ACIS::Web::Handler::Affiliations::add    ($self)
     if $action eq 'add';
    ACIS::Web::Handler::Affiliations::remove ($self)
     if $action eq 'remove';
    ACIS::Web::Handler::Affiliations::search ($self)
     if $action eq 'search';
   }

  my $search = $self -> session -> {'search'};
  $self -> variables -> {'search'} = $search
   if defined $search and ref( $search->{items} ) 
    and scalar @{$search -> {'items'}};
   
  my $affiliations = $self -> session -> current_record -> {'affiliations'};
  $self -> variables -> {'affiliations'} = $affiliations
   if defined $affiliations and scalar @$affiliations;
  
 }

sub new_institution
 {
  my $self = shift;
  
  my $cgi = $self -> request -> {CGI};
  my $configuration = $self -> config;
  my $session = $self -> session;
  
  my $action = $self -> get_form_value ('action');

  ACIS::Web::Handler::Affiliations::add ($self)
   if ($cgi -> param ('add-institution'));
  
  $self -> send_mail ('email-new-institution.xsl');
  
  $self -> redirect_to_screen ('affiliation');
 }

sub unregister
 {
  my $self = shift;

  my $paths = $self -> paths;
    
  my $userdata = $paths -> {'user-data'};
  my $deleted_userdata = $paths -> {'deleted-user-data'};
  my $lock = $paths -> {'lock'};
  my $session = $paths -> {'session'};
  
  debug "rename user-data from '$userdata' to '$deleted_userdata'";
    
  rename $userdata, $deleted_userdata;
    
  debug "remove lock at '$lock' and remove session at '$session'";
    
  unlink $lock;
  unlink $session;
    
  $self -> send_mail ('email-delete-account.xsl');
    
  $self -> {'session'} = undef; 
    
  $self -> redirect ($self -> config -> {'base-url'});
   
 }

sub outside_profile
 {
  my $self = shift;
  
  my $affiliations = $self -> session -> current_record -> {'affiliations'};
  if (defined $affiliations and scalar @$affiliations)
   { $self -> variables -> {'affiliations'} = $affiliations; }
 }


sub logoff
 {
  debug "processing logoff service screen";
  
  my $self = shift;
  
  #  user-data  session -> user-data
  
  my $content;
  
  if (open USERDATA, $self -> paths -> {'user-data'})
   {
    my $irs = $/;
    undef $/;
    
    $content = <USERDATA>;
    close USERDATA;
    
    $/ = $irs;
   }
  else
   {
    
   } 
  my $session_content = $self -> session -> {'user-data'} -> dump_xml;
  
  if ($session_content ne $content)
   {
    debug 'found some changes';
    
    my $record = $self -> session -> current_record;
    
    #  personal page
    
    my $pattern = 'user-outside-profile.xsl';
    my $path = $self -> paths -> {'personal-path'};
    
    my $config  = $self -> config;
    
    my $pattern_path = $self -> paths -> {'presenters'} . '/' . $pattern;
    
    if (open HTML, '> ' . $self -> paths -> {'personal-path'} . 'html')
     {
      print HTML ACIS::Web::launch_presenter
       ('xslt', dump_xml ($self -> {'presenter-data'}), $pattern_path );
      
      close HTML;
     }
    
    &ACIS::Web::Handler::Affiliations::commit ($self);
    
    #   ,   .
    
    $self -> send_mail ('email-user-data-changes.xsl');
    
    #       user-data   .
    
    $self -> session -> {'user-data'} -> save ($self -> paths -> {'user-data'});
    
   }
  #  
  
  my $lock = $self -> paths -> {'lock'};
  my $session = $self -> paths -> {'session'};
    
  debug "remove lock at '$lock' and remove session at '$session'";
    
  unlink $lock;
  unlink $session;
  $self -> {'session'} = undef;
   
  # $self -> redirect ($self -> variables -> {'base-url'});
  
 }

1;
