package ACIS::Web::Handler::NewUser;

use strict;
use warnings;

use Data::Dumper;
use Carp::Assert;

use CGI::Untaint;

use ACIS::Common;

use ACIS::Data::DumpXML qw( &dump_xml );

use ACIS::Web::Handler::Main;

use RePEc::ShortIDs::Client;



sub initial_prepare
 {
  my $app = shift;

  my ($year, $month, $day) = (localtime)[5, 4, 3];
    
  $app -> set_form_value ( 'year',  $year + 1900 );
  $app -> set_form_value ( 'month', $month + 1 );
  $app -> set_form_value ( 'day',   $day );
  
  
  
  return;
 }



#      .  ,  
# ,  ,    .  ,  
# session, userdata,  redirect,    hardcoded.

sub initial_process
 {
  debug "running initial service screen";
  
  my $app = shift;

  debug 'found some parameters, processing received user data';

  if ($app -> get_form_value ('pass') ne $app -> get_form_value ('pass-confirm'))
   {
    $app -> variables -> {'error'} = 'password-confirmation-mismatch';
    $app -> clear_process_queue;
    return;
   }

  debug "creating session";
    
  my $owner = {};

  $owner -> {IP} = $ENV{'REMOTE_ADDR'};

  my $session = $app -> create_session ($owner, 'new-user');
  
  my $sid = $session -> id;
  
  debug "new session created: $sid";

  ### XXX here we create initial user-data structure.  
  ### for that matter we should ask someone more educated

  $session -> {'user-data'} = 
    {
     'owner' => {},

     ### too ACIS specific
     ### does not belong here
     'records' => 
     [
      {
#       'name' => {},
#       'name-variations' => [],
      },
     ],
    };
  
  $app -> redirect_to_screen ('new-user/additional');

}


sub additional_prepare
 {
  my $self = shift;
  
  my $session = $self -> session;

  debug "preparing personal data service screen";
  
  if ( $session -> type ne 'new-user' )
   {
    $self -> error( 'session-wrong-type' );
    $self -> clear_process_queue;
    $self -> set_presenter( 'sorry' );
    return;
   }
  
  $self -> set_form_value ('name-variations',
   join "\n", @{ $session -> current_record -> {'name-variations'} });
 }


sub additional_process
 {
  my $self = shift;
  
  my $session = $self -> session;

  debug "running personal data service screen";
  
  if ( $session-> type ne 'new-user' )
   {
    $self -> error( 'session-wrong-type' );
    $self -> clear_process_queue;
    $self -> set_presenter( 'sorry' );
    return;
   }

  $session -> current_record -> {'name-variations'} = 
    [split (/\s*[\n\r]+/, $self -> get_form_value ('name-variations'))];
  $self -> redirect_to_screen ('new-user/affiliation');
 }


sub affiliation_main
 {
  my $self = shift;
  
  my $search = $self -> session -> {'search'};
  $self -> variables -> {'search'} = $search
   if defined $search and ref( $search->{items} ) 
    and scalar @{$search -> {'items'}};
   
  my $affiliations = $self -> session -> current_record -> {'affiliations'};
  $self -> variables -> {'affiliations'} = $affiliations
   if defined $affiliations and scalar @$affiliations;
 }


sub affiliation_process
 {
  debug "running affiliation service screen";
  
  my $self   = shift;
  
  my $session = $self -> session;
  my $cgi    = $self -> request -> {CGI};

  if ( $session-> type ne 'new-user' )
   {
    $self -> error( 'session-wrong-type' );
    $self -> clear_process_queue;
    $self -> set_presenter( 'sorry' );
    return;
  }

  my $action = $self -> get_form_value ('action');
   
  if ($action eq 'continue')
   {
#      ACIS::Web::Handler::Affiliations::commit ($self);
    $self -> redirect_to_screen ('new-user/complete');
   }
  else
   {
    ACIS::Web::Handler::Affiliations::add    ($self)
     if $action eq 'add';
    ACIS::Web::Handler::Affiliations::remove ($self)
     if $action eq 'remove';
    ACIS::Web::Handler::Affiliations::search ($self)
     if $action eq 'search';
   }

  my $search = $self -> session -> {'search'};
  $self -> variables -> {'search'} = $search
   if defined $search and ref( $search->{items} ) 
    and scalar @{$search -> {'items'}};
   
  my $affiliations = $self -> session -> current_record -> {'affiliations'};
  $self -> variables -> {'affiliations'} = $affiliations
   if defined $affiliations and scalar @$affiliations;

 }

sub new_institution
 {
  my $self = shift;
  
  my $session = $self -> session;
  if ( $session-> type ne 'new-user' )
   {
    $self -> error( 'session-wrong-type' );
    $self -> clear_process_queue;
    $self -> set_presenter( 'sorry' );
    return;
   }
  
  #???
  # place email code here
  
  $self -> redirect_to_screen ('new-user/affiliation');
 }
 
sub complete
 {
  debug "running new user registration complete service screen";
  
  my $app = shift;
  my $session = $app -> session;
  

  if ( $session-> type ne 'new-user' )
   {
    $app -> error( 'session-wrong-type' );
    $app -> clear_process_queue;
    $app -> set_presenter( 'sorry' );
    return;
   }

  debug Dumper $session -> {'user-data'};

  my $dumped_data = dump_xml ($session -> {'user-data'});
  
  debug "data dumped, try generate confirmation-id";
  
  my $path = $app -> {'home'} . '/unconfirmed/';
  my $confirmation_id = $session -> {'confirmation-id'};
  
  unless (defined $confirmation_id)
   {{
    $confirmation_id = generate_id;
  
    while (-f "$path$confirmation_id.xml")
     {
      $confirmation_id = generate_id;
     }
    
    next unless open DUMPED, "> $path$confirmation_id.xml"; 
   }}

  debug "confirmation-id: '$confirmation_id'";

  $session -> {'confirmation-id'} = $confirmation_id;

  
  print DUMPED $dumped_data;
  close DUMPED;
 
  my $configuration = $app -> config;
  
  my $confirmation_url = $configuration->{'base-url'}
        . '/confirm!' . $confirmation_id;

  $app -> variables -> {'confirmation-url'} = $confirmation_url;
  
  debug "the <a href='$confirmation_url'>confirmation url</a>";
  
  $app -> send_mail ('email/confirmation.xsl');

 }

sub confirm
 {
  my $self = shift;
  
  debug "running new user confirmation screen";
  my $confirmation_id = $self -> request -> {'session-id'};
  
  debug "received '$confirmation_id', try open file " . $self -> paths -> {'unconfirmed'};

  if ( not -f $self -> paths -> {'unconfirmed'})
   {   
    $self -> error ('confirmation-bad');
    $self -> clear_process_queue;
    return;
   }
  
  my $udata = $self -> user_data ($self -> paths -> {'unconfirmed'});
  
  my $login = $udata -> {'owner'} -> {'login'};

  $udata -> changed;
  
  my $record = $udata -> {records} -> [0];
  
  # get short-id for a person 
  my $handle = $record -> {'handle'};
  my $name   = $record -> {'name'} -> {'last'};

  my $sid = 
   RePEc::ShortIDs::make_up_short_id_for_a_person
     ($handle, $name);

  unless (defined $sid)
   {
    critical "we try to receive short-id, but receiver is bad ;-) ";
   }
  
  $record -> {'short-id'} = $sid;
  
  debug Dumper $udata;
  
  my $word_login = $login;
  $word_login =~ s/\W//g;

  my $fl = substr ($word_login, 0, 1);
  my $sl = substr ($word_login, 1, 1);
  
  force_dir ($self -> {'home'} . '/userdata', "$fl/$sl");
  
  $self -> {'paths'} -> {'user-data'} = $self -> {'home'} . "/userdata/$fl/$sl/$login.xml";
  
  $udata -> save ($self -> paths -> {'user-data'});
  
  debug "saving user-data at " . $self -> paths -> {'user-data'};
  
  unlink $self -> paths -> {'unconfirmed'}
   unless $ACIS::DEBUG;
  
  debug "deleted unconfirmed user-data at " . $self -> paths -> {'unconfirmed'};
 }

1;
