package ACIS::Web::Handler::Main;

use strict;
use Data::Dumper;
use Carp::Assert;

use ACIS::Common;
use ACIS::Data::DumpXML qw(dump_xml);
use ACIS::Web;


sub prepare_user
 {
  my $self = shift;
  
  my $record = $self -> session -> current_record;
  
  debug ( Dumper $record );

  assert( $record->{name} );
  assert( $record->{name} -> {last} );

  my $name         = $record -> {name};

  my $first_name   = $name -> {first};
  my $second_name  = $name -> {middle};
  my $last_name    = $name -> {last};
  my $first_small  = substr $first_name, 0, 1;
    
  my $full_name = "$first_name $second_name $last_name";

  $full_name =~ s/\s+/ /g;
    
  $record -> {'full-name'} = $full_name;
  $self -> session -> {'user-data'} -> {owner} -> {name} = $full_name;

  my $handle_name = "$last_name $second_name $first_name";
    
  $handle_name = uc $handle_name;
  $handle_name =~ s/[^a-z]/_/gi;
  $handle_name =~ s/_+/_/g;
  $handle_name =~ s/\s+/ /g; 
    
  my $year  = $record -> {'year'};
  my $month = $record -> {'month'};
  my $day   = $record -> {'day'};
    
  unless ($year or $month or $day)
   {
    ($day, $month, $year) = (localtime)[3,4,5];
    $year += 1900;
    $month ++;
   } 
    
  $month = "0$month"
   if $month < 10;
  $day = "0$day"
   if $day < 10;
  
  my $config = $self -> config;
  my $prefix = $config -> {'person-id-prefix'};
                      
  my $handle = "$prefix$year-$month-$day:$handle_name";
  
  $record -> {type} = 'person';


  ### generate initial name variations
  $record -> {'name-variations'} = 
   [
    "$first_name $last_name",
    "$first_small. $last_name",
    "$last_name, $first_name",
    "$last_name, $first_small."
   ];
  
  if ($second_name) 
   {
    my $second_small = substr $second_name, 0, 1;
    push @{$record -> {'name-variations'}},
     (
      "$first_name $second_name $last_name",
      "$first_name $second_small. $last_name",
      "$first_small. $second_small. $last_name",
      "$last_name, $first_name $second_name",
      "$last_name, $first_name $second_small.",
      "$last_name, $first_small. $second_small."
     );
   }
  $record -> {handle} = $handle;  # XXX leave out this one
  $record -> {id}     = $handle;
 }

1;

