package ACIS::Web::Handler::Affiliations;

use strict;
use ACIS::Common;

sub prepare
 {
  my $self = shift;
  
  debug "preparing affiliations - copying unfolded and resolve handles into institutions";
  
  my $affiliations = $self -> session -> current_record -> {'affiliations'};
  my @handles = ();
  my $statement = 'select * from institutions where';
  
  my $unfolded = [];
  
  return
   unless defined $affiliations and scalar @$affiliations;
   
  foreach (@$affiliations)
   {
    if (ref $_ eq 'HASH')
     {
      push @$unfolded, $_;
     }
    else 
     {
      push @handles, $_;
      $statement .= ' handle=? and';
     }
   }

  if (scalar @handles)
   {
    # kill final ' and'
    substr($statement, -4) = "";
    
    my $sql = $self -> sql_object;
    
    debug "sql statement: '$statement'";
    
    $sql -> prepare ($statement);
    my $sql_res = $sql -> execute (@handles);
    
    unless (defined $sql_res)
     {
      $self -> errors ('db-select-error');
      log_error "select error text: " . $sql -> error;
      debug "select error";
     }
    
    my $search_results = $sql_res -> {rows};
       
    while ($search_results--)
     {  
      my $institution = $sql_res -> {row};
      
      push @$unfolded, $institution;
      $sql_res -> next;
     }
    $sql_res -> next;
   }
  # $self -> session -> {'affiliations'} = $unfolded;
  $self -> session -> current_record -> {'affiliations'} = $unfolded;
 }

use Data::Dumper;

sub add
 {
  my $self = shift;
  
  my $affiliation = $self -> get_form_value ('affiliation');
  
  debug 'try to add affiliation';
  
  my $session = $self -> session;
  
  my $search_items = $session -> {'search'} -> {'items'};
  
  # in xslt defined 'affiliations' and 'search' array items
  if ($affiliation =~ /^\d+$/)
   {
    debug 'number of affiliation in search items received';
    
    if ($#{$search_items} < $affiliation)
     {
      $self -> error ('adding-affiliation-not-found');
      $self -> clear_process_queue;
      return;
     } 
    
    my $institution = $search_items -> [$affiliation];
    
    #debug Dumper $institution;
    foreach (@{$session -> current_record -> {'affiliations'}})
     {
      if
       (defined $_ -> {'handle'}
        and $_ -> {'handle'} eq $institution -> {'handle'})
       {
        $self -> error ('adding-affiliation-duplicate');
        $self -> clear_process_queue;
        return;
       }
     }
    
    $institution = splice @{$search_items}, $affiliation, 1;
    
    $session -> {'search'} -> {'results'} --;
    push @{$session -> current_record -> {'affiliations'}}, $institution;
   }
  # in xslt uses handles
  elsif (defined $affiliation)
   {
    #debug Dumper $search_items;
    
    return
     unless defined $search_items and scalar @$search_items;
    
    foreach (@{$session -> current_record -> {'affiliations'}})
     {
      if
       (defined $_ -> {'handle'}
        and $_ -> {'handle'} eq $affiliation)
       {
        $self -> error ('adding-affiliation-duplicate');
        $self -> clear_process_queue;
        return;
       }
     }
    
    my $institution;
    
    my $counter = 0;
    foreach (@$search_items)
     {
      if ($_ -> {'handle'} eq $affiliation)
       {
        $institution = 'found';
        last;
       }
      $counter++; 
     }
    
    if ($institution)
     {
      $institution = splice @$search_items, $counter, 1;
      push @{$session -> current_record -> {'affiliations'}}, $institution;
      $session -> {'search'} -> {'results'} --;
     }
    else
     {
      my $sql = $self -> sql_object;
    
      $sql -> prepare ('select * from institutions where handle=? limit 1');
      my $sql_res = $sql -> execute ($affiliation);
    
      unless (defined $sql_res)
       {
        $self -> errors ('db-select-error');
        log_error "select error text: " . $sql -> error;
        debug "select error";
       }
    
      my $search_results = $sql_res -> {rows};
             
      while ($search_results--)
       {  
        my $institution = $sql_res -> {row};
      
        push @{$session -> current_record -> {'affiliations'}}, $institution;
        $sql_res -> next;
       }
      $sql_res -> next;
     } 
     
   }
  # adding a new institution
  else
   {
    push @{$session -> current_record -> {'affiliations'}}, 
     {
      'name'         => $self -> get_form_value ('name'),
      'english-name' => $self -> get_form_value ('english-name'),
      'location'     => $self -> get_form_value ('location'),
      'homepage'     => $self -> get_form_value ('site'),
      'email'        => $self -> get_form_value ('email'),
      'postal'       => $self -> get_form_value ('postal'),
      'phone'        => $self -> get_form_value ('phone'),
      'fax'          => $self -> get_form_value ('fax'),
     };
   }
  
 }

sub remove
 {
  my $self = shift;
  
  my $session = $self -> session;
  my $affiliations = $session -> current_record -> {'affiliations'};
  
  return 
   unless defined $affiliations and scalar @$affiliations;    
  
  my $affiliation = $self -> get_form_value ('affiliation');
  
  if ($affiliation =~ /^\d+$/)
   {
    return if $#$affiliations < $affiliation;
    splice @$affiliations, $affiliation, 1;
   }
  else
   {
    my $counter = 0;
    my $found;
      
    foreach my $institution (@$affiliations)
     {
      if ($institution -> {handle} eq $affiliation)
       {
        $found = 'yes';
        last;
       }
      $counter++;
     }
    if ($found)
     { splice @$affiliations, $counter, 1; }
   } 
  
 }
 
sub commit
 {
  my $self = shift;
  
  my $unfolded_affiliations = $self -> session -> current_record -> {'affiliations'};
  my $affiliations = [];

  foreach (@$unfolded_affiliations)
   {
    my $handle = $_ -> {'handle'};
    if (defined $handle and $handle)
     { push @$affiliations, $handle; }
    else
     { push @$affiliations, $_; } 
   }
  $self -> session -> current_record -> {'affiliations'} = $affiliations;
 }



sub search
 {
  my $self = shift;
  
  my $cgi  = $self -> request -> {CGI};
  my $sql  = $self -> sql_object;
  my $session = $self -> session;

  my $what = '%' . $cgi -> param ('search-what') . '%';
  my $type = $cgi -> param ('search-by');
  
  my $statement = '';
  my @handles   = ();
  my $affiliations = $session -> current_record -> {'affiliations'};
  if (defined $affiliations and scalar @$affiliations)
   {
    foreach (@$affiliations)
     {
      next unless $_ -> {'handle'};
      $statement .= ' and handle!=?';
      push @handles, $_ -> {'handle'};
     }
   }
      
  return
   unless ($type =~ /location|name/);
      
  $sql -> prepare ("select * from institutions where $type like ? $statement limit 51");
  my $sql_res = $sql -> execute ($what, @handles);
      
  unless (defined $sql_res)
   {
    push @{$self -> variables -> {'errors'}}, 'db-select-error';
    return;
   }
      
  my $search_results = $sql_res -> {rows};
      
  if ($search_results > 50)
   {
    push @{$self -> variables -> {'errors'}}, 'db-select-too-many-results';
   }
      
  my $search = {};
  $search -> {'results'} = $sql_res -> {rows};
      
  # name, email, postal, phone, fax, homepage, location
    
  while ($search_results--)
   {  
    my $search_item = $sql_res -> {row};
    push @{ $search -> {'items'} }, $search_item;
        
    $sql_res -> next;
   }

  $sql_res -> next;
      
  $self -> variables -> {'search'} = $search;
  $session -> {'search'} = $search;

 }

1; 
