<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">
  
  <xsl:import href='../general/pages.xsl'/>
  <xsl:import href='../general/forms.xsl'/>
  
  
  <!--   p a g e   -->

  <xsl:template match='/data'>

    <xsl:call-template name='registered-user-page'>

      <xsl:with-param name='title'>submit a new institution</xsl:with-param>
      
      <xsl:with-param name='content' xml:space='preserve'>

        <h2>new institution</h2>

        <xsl:call-template name='show-status'/>

        <form xsl:use-attribute-sets='form'>

          <xsl:call-template name='fieldset'>
            <xsl:with-param name='content' xmlns='http://x'>
              <p>
        <label>Institution name in original language, required:<br />
         <input name='name' size='50'/><br/>
        </label>
        
        <label>Institution name in English, optional:<br />
         <input name='english-name' size='50'/><br/>
        </label>

        <label>Institution location, required:<br />
         <input name='location' size='50'/><br/>
        </label>

        <label>Website address, required:<br />
         <input name='homepage' size='50'/><br/>
        </label>

        <label>Email address, optional:<br />
         <input name='email' size='50'/><br/>
        </label>
        
        <xsl:if test='$form-values/handle'>

          <label>postal address
            <br/>
            <input name='postal' size='50'/><br/>
          </label>
        
          <label>phone
            <br/>
            <input name='phone' size='50'/><br/>
          </label>
          
          <label>fax
            <br/>
            <input name='fax' size='50'/><br/>
          </label>
          
          <input type='hidden' name='handle'/>
          
        </xsl:if>


        <!-- XXX: is this normal? -->

        <label for='add-institution'>add entered institution to my personal profile</label>
        <input type='checkbox' name='add-institution' id='add-institution' checked='yes' /><br/>

        <input type='submit' name='action' value='submit'/>
      </p>

     </xsl:with-param>
   </xsl:call-template> <!-- /fieldset -->
  </form>
</xsl:with-param>
</xsl:call-template> <!-- /registered-user-page -->

 </xsl:template>

</xsl:stylesheet>