<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">

  <xsl:import href='../general/pages.xsl'/>
  <xsl:import href='../general/forms.xsl'/>


  <!--    t h e   p a g e  -->
  
  <xsl:template match='/data'>
    <xsl:call-template name='registered-user-page'>
      <xsl:with-param name='title'>Name and contact details</xsl:with-param>
      <xsl:with-param name='content' xml:space='preserve'>

        <h1>Name and contact details</h1>
        
        <xsl:call-template name='show-status'/>
        
    <form xsl:use-attribute-sets='form'>
     <h2>Your name</h2>
     <xsl:call-template name='fieldset'>
      <xsl:with-param name='content' xmlns='http://x'>
       <p>
        <label>Your full name, required:<br />
         <input name='full-name' size='50'/>
        </label>
       </p>
       <p>
        <label>First name, required:<br/>
         <input name='first-name' size='50'/>
        </label><br />
        <label>Middle name:<br />
         <input name='middle-name' size='50'/>
        </label><br />
        <label>Last name, required:<br />
         <input name='last-name' size='50'/>
        </label>
       </p>

       <p>
        <label>The variations of your name, one per line:<br />
         <textarea name='name-variations' cols='50' rows='10'/>
        </label>
       </p>

       <h2>Contact details</h2>
       <p>
        <label>Email address.  Required: <br />
         <input name="email" size="50" maxsize="60" />
        </label><br />

        <label>
          <input name="mail-pub" type="checkbox" value='true' /> Include the email in my
         public profile</label>
       </p>
              
       <p>
        <label>Your personal homepage, optional:<br />
         <input name="homepage" size="50" maxsize="90" />
        </label><br />
                  
        <label>Your phone number, optional:<br />
         <input name="phone" size="20" maxsize="40" />
        </label><br />
                    
        <label>Your postal address, optional:<br />
         <textarea name="postal" type="text" rows="5" cols="50"/>
        </label>
       </p>
                
      </xsl:with-param>
     </xsl:call-template>
     <input type='submit' value='continue'/> 
    </form>
  </xsl:with-param>
</xsl:call-template>
</xsl:template>

</xsl:stylesheet>
