<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">
  
  <xsl:import href='../general/pages.xsl'/>
  
  <xsl:template match='/data'>

    <xsl:variable name='person' select='$form-values'/>

    <xsl:call-template name='page'>
      <xsl:with-param name='title'>profile</xsl:with-param>
      <xsl:with-param name='content' xml:space='preserve'>

        <h1><xsl:value-of select='$person/full-name'/></h1>
    <h2>Names</h2>

    <table>
      <tr>
        <td class='fld'>first:</td>
        <td class='val'><xsl:value-of select='$person/first-name'/></td>
      </tr>
      <xsl:if test='$person/middle-name/text()'>
        <tr>
          <td class='fld'>middle:</td>
          <td class='val'><xsl:value-of select='$person/middle-name'/></td>
        </tr>
      </xsl:if>
      <tr>
        <td class='fld'>last:</td>
        <td class='val'><xsl:value-of select='$person/last-name'/></td>
      </tr>
    </table>

    <!--
    <p> 
     <xsl:call-template name='field-value'><xsl:with-param name='name' select='"first-name"'
      /></xsl:call-template>
     <xsl:if test='/data/form-data/middle-name/text()'
     ><xsl:call-template name='field-value'><xsl:with-param name='name' select='"middle-name"'
      /></xsl:call-template></xsl:if>
     <xsl:call-template name='field-value'><xsl:with-param name='name' select='"last-name"'
      /></xsl:call-template>
    </p>
    --> 

    <h2>Contact</h2>

    <table>

      <xsl:if test='$person/mail-pub/text()'>
        <tr>
          <td class='fld'>email:</td>
          <td class='val'><xsl:value-of select='$person/email'/></td>
        </tr>
      </xsl:if>

      <xsl:if test='$person/homepage/text()'>
        <tr>
          <td class='fld'>homepage:</td>
          <td class='val'><a href='{$person/homepage}'><xsl:value-of select='$person/homepage'/></a></td>
        </tr>
      </xsl:if>
      
      <xsl:if test='$person/phone/text()'>
        <tr>
          <td class='fld'>phone:</td>
          <td class='val'><xsl:value-of select='$person/phone'/></td>
        </tr>
      </xsl:if>

      <xsl:if test='$person/postal/text()'>
        <tr>
          <td class='fld'>postal address:</td>
          <td class='val'><xsl:value-of select='$person/postal'/></td>
        </tr>
      </xsl:if>
      
    </table>


    <!--
    <p>
     <xsl:if test='/data/form-data/mail-pub/text()'>
      <xsl:call-template name='field-value'><xsl:with-param name='name' select='"email"'
       /></xsl:call-template>
     </xsl:if>
     <xsl:if test='/data/form-data/homepage/text()'>
      <xsl:call-template name='field-value'><xsl:with-param name='name' select='"homepage"'
      /></xsl:call-template>
     </xsl:if>
     <xsl:if test='/data/form-data/phone/text()'>
      <xsl:call-template name='field-value'><xsl:with-param name='name' select='"phone"'
      /></xsl:call-template>
     </xsl:if>
     <xsl:if test='/data/form-data/postal/text()'>
      <xsl:call-template name='field-value'><xsl:with-param name='name' select='"postal"'
      /></xsl:call-template>
     </xsl:if>
    </p>

-->

    <xsl:if test='$response-data/affiliations/list-item'
      ><h2>Affiliations</h2>
     <p>
      <ul
       ><xsl:apply-templates select='$response-data/affiliations'
       /></ul>
     </p>
    </xsl:if>

    <xsl:if test='$person/sci-fields/text()'
     ><h2>areas of interests</h2>
     <p>
       <xsl:value-of select='$person/sci-fields/text()'/>
     </p>
    </xsl:if>
   </xsl:with-param>
 </xsl:call-template> <!-- /page -->
 </xsl:template>



 <xsl:template match="*" mode='organization-details'>
<xsl:if test='text()' xml:space='preserve'
>    <li><xsl:value-of select='local-name(.)' />: <xsl:value-of select='text()'/></li>
</xsl:if>
 </xsl:template>


 <xsl:template match='affiliations/list-item|items/list-item' xml:space='preserve'>
  <li>
   <b><xsl:choose
   ><xsl:when test='homepage/text()'
   ><a href='{homepage/text()}'><xsl:value-of select='name/text()'/></a
   ></xsl:when
   ><xsl:otherwise><xsl:value-of select='name/text()'/></xsl:otherwise
   ></xsl:choose></b>
   <ul>
    <xsl:if test='email/text()'
    ><li>e-mail: <xsl:value-of select='email/text()' /></li></xsl:if>
    <xsl:apply-templates select='postal|phone|fax|location' mode='organization-details'/>
   </ul>
  </li>
 </xsl:template>


</xsl:stylesheet>

