<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">
  
  <xsl:import href='general/pages.xsl'/>
  <xsl:import href='general/forms.xsl'/>
  
  <xsl:template match='text()'/>

  <xsl:template match="/data">
    <xsl:call-template name='page'>
      <xsl:with-param name='title'>Log in</xsl:with-param>
      <xsl:with-param name='body-title'>Log in</xsl:with-param>
      
      <xsl:with-param name='headers' xml:space='preserve'>
      <!-- [iku] what is this for?
           <script>
           <![CDATA[
             function show_help (control)
             { control.innerHTML="<br/>if your browser supported cookie and it is enabled, you may save your login and pass and next login do not enter it<br/><br/>"; }]]>
         </script> 
         -->
       </xsl:with-param>
       <xsl:with-param name='content' xml:space='preserve'>

         <p>This is ACIS front page.</p>

         <xsl:call-template name='show-status'/>


         <form action='{$base-url}/welcome' xsl:use-attribute-sets='form'>

    <p>
      <xsl:call-template name='fieldset' xml:space='default'>
        <xsl:with-param name='content' xmlns='http://x' xml:space='preserve'>

     <label>email address:<br />
     <input name='login' size='50'/></label><br />

     <label>password:<br />
     <input name='pass' type='password' /></label><br />

     <input type='checkbox' name='auto-login' id='auto-login' />
     <label for='auto-login'>save login and password in a cookie</label>
    </xsl:with-param>
  </xsl:call-template> <!-- /fieldset -->

<br />
   <span id='auto_login_help'> </span>
   <input type='submit' value='log in' />
   </p>
   
   </form>



   <p><a href='{$base-url}/forgotten-password'>Forgot your password?</a></p>

   <p><a href='{$base-url}/new-user'>Register as a new user</a>.</p>
  
    </xsl:with-param>
  </xsl:call-template> <!-- /page -->
  </xsl:template>


</xsl:stylesheet>

