<!DOCTYPE xsl:stylesheet [

<!ENTITY nbsp   "&#160;"> <!-- no-break space = non-breaking space,
                               U+00A0 ISOnum -->

]>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  exclude-result-prefixes='exsl xml x'
  version="1.0">
 
  <xsl:output
    method='xml'
    doctype-public='-//W3C//DTD XHTML 1.0 Strict//EN'
    doctype-system='http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
    omit-xml-declaration='yes'
    encoding='utf-8'/>

  
<!-- GLOBAL VARIABLES  --> 

<!-- main ones -->
 
<xsl:variable name='root'       select='/'/>
<xsl:variable name='system'     select='/data/system'/>
<xsl:variable name='config'     select='/data/system/config'/>
<xsl:variable name='request'    select='/data/request'/>
<xsl:variable name='response'   select='/data/response'/>

<!-- configuration -->

<xsl:variable name='base-url'   select='$config/base-url/text()'/>
<xsl:variable name='site-name'  select='$config/site-name/text()'/>
<xsl:variable name='help-url'   select='$config/help-url/text()'/>
<xsl:variable name='admin-email'  select='$config/admin-email/text()'/>
<xsl:variable name='debug-mode' select='$config/debug/text()'/>

<!-- request parts -->

<xsl:variable name='session'    select='$request/session'/>
<xsl:variable name='user'       select='$request/user'/>

<!-- request context and details -->

<xsl:variable name='session-id'   select='$session/id/text()'  />
<xsl:variable name='session-type' select='$session/type/text()'/>
<xsl:variable name='current-record' select='$session/current-record'/>

<xsl:variable name='record-id'    select='$current-record/id/text()'/>
<xsl:variable name='record-type'  select='$current-record/type/text()'/>
<xsl:variable name='record-name'  select='$current-record/name/text()'/>

<xsl:variable name='user-name'    select='$user/name/text()'/>
<xsl:variable name='user-login'   select='$user/login/text()'/>
<xsl:variable name='user-type'    select='$user/type/text()'/>

<xsl:variable name='form-input'   select='$request/form/input'/>

<xsl:variable name='request-screen'    select='$request/screen/text()'/>



<!-- response details -->

<xsl:variable name='error'   select='$response/error/text()'/>
<xsl:variable name='message' select='$response/message/text()'/>
<xsl:variable name='success' select='$response/success/text()'/>

<xsl:variable name='response-data' select='$response/data'/>

<xsl:variable name='form-action' select='$response/form/action/text()'/>
<xsl:variable name='form-values' select='$response/form/values'/>
<xsl:variable name='form-errors' select='$response/form/errors'/>


<xsl:variable name='any-errors' select='$error or $form-errors//list-item'/>

<!--
 <xsl:variable name='' select='/text()'/>
 <xsl:variable name='' select='/text()'/>
 <xsl:variable name='' select='/text()'/>
 <xsl:variable name='' select='/text()'/>
 <xsl:variable name='' select='/text()'/>
-->





 <!-- GLOBAL ACIS PAGE TEMPLATE -->


 <xsl:template name='page'>
   <xsl:param name='content'/>
   <xsl:param name='title'/>
   <xsl:param name='body-title'/>
   <xsl:param name='show-errors'/>
   <xsl:param name='headers'   />

<html xml:space='preserve'>
 <head>
  <title><xsl:value-of select='$site-name'/>: <xsl:value-of select='$title'/></title>
  <link rel="stylesheet" href="/css/acis.css" type="text/css"/>
  <xsl:copy-of select='$headers'/>
 </head>
 <body>


   <div class='header'>
     <p>
       <a href='{$base-url}'><xsl:value-of select='$site-name'/></a>
     <!-- | <a href='-{$help-url}-' title='now useless'>Help</a> 
          XXX help link -->
     </p>
   </div>
  
   <div class='content'>

   <xsl:if test='$body-title' xml:space='default'>
     <h1><xsl:value-of select='$body-title'/></h1>
   </xsl:if>

   <xsl:if test='$show-errors' xml:space='default'>
       <xsl:call-template name='show-errors'/>
   </xsl:if>

     <xsl:copy-of select='$content'/>

   </div>

   <div class='footer'>
     <p>
       <a href='mailto:{$admin-email}'>Administrator</a> |
       <a href='{$base-url}'>Home</a>

       <!-- XXX help link 
            | 
       <a href='{$base-url}/manual'>Help</a> -->
     </p>
   </div>


   <div class='debug'> <!--  bad boxes -->

     <p>&nbsp;</p>
     <p>&nbsp;</p>

     <hr/>
     
     <p>&nbsp;</p>
     
     <textarea cols='100' rows='30' style='font-size: 12px;'>
       <xsl:copy-of select='$system/debug-messages/text()'/>
     </textarea>
     
     <p>&nbsp;</p>
     
     <textarea cols='100' rows='40' style='font-size: 12px;'>
       <xsl:copy-of select='/'/>
     </textarea>
     
  <xsl:if test='$debug-mode="on"'>
  </xsl:if>

  </div>

 </body>
</html>
 </xsl:template>
 






 <!-- PAGE TEMPLATE FOR REGISTERED USER SCREENS -->


 
 <xsl:template name='registered-user-page-header'>
   <div id='header'>
     <p>Welcome <span class='name'>
     <xsl:value-of select='$user-name'/>
   </span>. 

   You can: 
   <a href='{$base-url}/outside-profile!{$session-id}'>see profile</a>,
   <a href='{$base-url}/logoff!{$session-id}'>logoff</a>.

   </p>   
  </div>
 </xsl:template>
 
 <xsl:template name='registered-user-page-footer'>
 </xsl:template>
 


 <xsl:template name='registered-user-page'>
   <xsl:param name='content'   />
   <xsl:param name='headers'   />
   <xsl:param name='title'     />

   <xsl:call-template name='page'>

     <xsl:with-param name='title'   select='$title'    />
     <xsl:with-param name='headers' select='$headers'  />
     <xsl:with-param name='content' xml:space='preserve'>

       <xsl:call-template name='registered-user-page-header'/>

  <div id='main'>
    <h1><xsl:value-of select='$record-name'/> Profile:</h1>  
  <!-- XXX this only looks good for person records -->
   <div id='user-menu'>
    <xsl:call-template name='user-menu'/>
   </div>

    <xsl:copy-of select='$content'/>
  </div>

  <xsl:call-template name='registered-user-page-footer'/>

     </xsl:with-param>

   </xsl:call-template>

 </xsl:template>
 



  <!--  MAIN  MENU   -->


  <xsl:template name='user-menu'>  
 <ul class='menu'>
   <li><a href='{$base-url}/personal-data!{$session-id}'
   >name and contact details</a></li>

   <li><a href='{$base-url}/affiliation!{$session-id}'
   >affiliation and employment profile</a></li>

   <li><a href='{$base-url}/sci-fields!{$session-id}'
   >scientific fields profile</a></li>
   
   <li><a href='{$base-url}/photo!{$session-id}'
   >upload photo</a></li>

   <li><a href='{$base-url}/contribution!{$session-id}'
   >academic contributions profile</a></li>

   <li><a href='{$base-url}/unregister!{$session-id}'
   >delete registration</a></li>
   
   <!--
   <li><a href='{$base-url}/logoff!{$session-id}'
   >leave and save changes</a></li>
   
   <li><a href='{$base-url}/outside-profile!{$session-id}'
   >current state of the profile</a></li>
-->

 </ul>

 </xsl:template>



 <!-- outdated errors template -->

 <xsl:template name='display-human-readable-errors'>

   <p>This page uses outdated <code
   >display-human-readable-errors</code> template.  Please use <code
   >show-errors</code> instead.</p>
 
 </xsl:template>




  <!--  SHOW  ERRORS  template  -->


  <xsl:template name='show-errors'>

    <xsl:variable name='errors-table' select='document("../errors.xml")' />
    <xsl:variable name='fields-table' select='document("../fields.xml")' />

    <div class='errors'>
      <xsl:if test='$error'>
        <xsl:variable name='errtext' select='$errors-table//error[@id=$error]/text()'/>
        <p>Error: 
        <xsl:if test='$errtext'>
          <xsl:value-of select='$errtext'/>
        </xsl:if>
        <xsl:if test='not($errtext)'>
          undescribed, code: <xsl:value-of select='$error'/>
        </xsl:if>
        </p>
      </xsl:if>

      <xsl:if test='/data/errors/list-item'>
        
        <p>Errors: (this should not be! XXX)</p>

        <ul>
        <xsl:for-each select='/data/errors/list-item'>

          <xsl:variable name='err' select='text()'/>
          <xsl:variable name='errtext' select='$errors-table//error[@id=$err]/text()'/>

          <li>
        <xsl:if test='$errtext'>
          <xsl:value-of select='$errtext'/>
        </xsl:if>
        <xsl:if test='not($errtext)'>
          undescribed, code: <xsl:value-of select='$err'/>
        </xsl:if>
          </li>
        </xsl:for-each>
      </ul>
    </xsl:if>

      <xsl:if test='$form-errors/required-absent/list-item'>
        <p>These fields are required:</p>
        <ul>
          <xsl:for-each select='$form-errors/required-absent/list-item'>
            <xsl:variable name='field' select='text()'/>
            <xsl:variable name='desc' select='$fields-table//field[@name=$field]/desc/text()'/>

            <li><xsl:value-of select='$desc'/></li>

          </xsl:for-each>
        </ul>
      </xsl:if>

      <xsl:if test='$form-errors/invalid-values/list-item'>
        <p class='error'>The values you entered into these fields are invalid:</p>
        <ul>
          <xsl:for-each select='$form-errors/invalid-values/list-item'>
            <xsl:variable name='field' select='text()'/>
            <xsl:variable name='desc' select='$fields-table//field[@name=$field]/desc/text()'/>

            <li><xsl:value-of select='$desc'/></li>

          </xsl:for-each>
        </ul>

      </xsl:if>
    </div>
  </xsl:template>



  <!--  SHOW  STATUS  -->

  <xsl:template name='show-status'>
    
    <xsl:if test='$any-errors'>
      <!-- XXX status itself -->
      <xsl:call-template name='show-errors'/>
    </xsl:if>
  
  </xsl:template>



 
 <xsl:attribute-set name='form'>
  <xsl:attribute name='action'><xsl:value-of select='$form-action'/></xsl:attribute>
  <xsl:attribute name='method'>post</xsl:attribute>
  <xsl:attribute name='enctype'>application/x-www-form-urlencoded</xsl:attribute>
  <xsl:attribute name='accept-charset'>utf-8</xsl:attribute>
 </xsl:attribute-set>



  <!--  LOGIN FORM  -->


  <xsl:template name='login-form' xml:space='preserve'>
    <xsl:param name='login'/>

    <form xsl:use-attribute-sets='form'>

      <p>
        <label>email address:<br />
        <input name='login' size='50' value='{$login}'/>
        </label><br/>

        <label>password:<br/>
        <input name='pass' type='password'/>
        </label><br/>

        <label><input type='checkbox' name='auto-login' id='auto-login'/>
        save login and password in a cookie</label>
        
        <br/>
        <input type='submit' value='continue'/>
      </p>
        
      </form>

      <p><a href='{$base-url}/forgotten-password'>Forgot your password?</a></p>
      
      <p><a href='{$base-url}/new-user'>Register as a new user</a>.</p>

  </xsl:template>
  

</xsl:stylesheet>
