<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:import href='../general/pages.xsl'/>
  <xsl:import href='../general/forms.xsl'/>


  <!--    v a r i a b l e s    -->

  <xsl:variable name='affiliations' select='$response-data/affiliations'/>
  <xsl:variable name='search'       select='$response-data/search'/> 
  <xsl:variable name='found-items'  select='$search/items'/> 
  <xsl:variable name='search-what'  select='$form-values/search-what/text()'/> 


  <!--   u t i l i t y   t e m p l a t e   -->

  <xsl:template name='show-institutions'>
    <xsl:param name='list'/>
    <xsl:param name='mode'/>
    
    <xsl:for-each select='$list/list-item' xml:space='preserve'>
      <li><xsl:value-of select='name'/>

      <form xsl:use-attribute-sets='form'>
        <input type='hidden' name='affiliation' value='{handle}'/>
        <input type='submit' name='action' value='{$mode}'/>
      </form>


      <ul class='institution-details'>
        <xsl:if test='location/text()'>
          <li>located in: <xsl:value-of select='location/text()'/></li>
        </xsl:if>
        <xsl:if test='homepage'>
          <li><a href='{homepage}'>website</a></li>
        </xsl:if>
        <xsl:if test='email/text()'>
          <li>email: <xsl:value-of select='email/text()'/></li>
        </xsl:if>
        <xsl:if test='postal/text()'>
          <li>postal address: <xsl:value-of select='postal/text()'/></li>
        </xsl:if>
        <xsl:if test='phone/text()'>
          <li>phone: <xsl:value-of select='phone/text()'/></li>
        </xsl:if>
        <xsl:if test='fax/text()'>
          <li>fax: <xsl:value-of select='fax/text()'/></li>
        </xsl:if>
        <!-- XXX not all fields show here -->

      </ul>


    </li>

    </xsl:for-each>
  </xsl:template>




  <!--   n o w   t h e   p a g e   t e m p l a t e    -->

  
  <xsl:template match='/data'>
    
    <xsl:variable name='content' xml:space='preserve'>

        <h1>Affiliation profile</h1>
        
        <h2>Now:</h2>
        
        <xsl:call-template name='show-status'/>
        
        <p>
          <xsl:if test='$affiliations/list-item'>
            <ul>
              <xsl:call-template name='show-institutions'>
                <xsl:with-param name='list' select='$affiliations'/>
                <xsl:with-param name='mode' select='"remove"'/>
              </xsl:call-template>
              <!--  <xsl:apply-templates select='affiliations'/>  -->
            </ul>
          </xsl:if>
          <xsl:if test='not( $affiliations/list-item )'>
            You are currently not associated with any organization.
          </xsl:if>
        </p>
      
        <h2>Search:</h2>
        

        <xsl:call-template name='fieldset'><xsl:with-param name='content'>
        <form xmlns='http://x' xsl:use-attribute-sets='form'>
          <p>
            <input name='search-what' value='{$search-what}'/> 
            <input type='submit' name='action' value='search'/>
            
            <br/>
            <input type='radio' name='search-by' id='search-by-location' value='location'/>
            <label for='search-by-location'>by location</label>

            <label for='search-by-name'>
            <input type='radio' name='search-by' id='search-by-name' value='name' checked='1'/> 
              by name</label>
          </p>
          
        </form> 
        </xsl:with-param></xsl:call-template> <!-- /fieldset -->
                
   
        <xsl:if test='$search'>

          <xsl:if test='count($found-items/list-item)'>
            <form xsl:use-attribute-sets='form'>
              <p><input type='submit' name='action' value='continue'/></p>
            </form>
          </xsl:if>

     
          <h2>Search: found <xsl:value-of select='$search/results/text()'/> records.</h2>
     
          <xsl:if test='count($found-items/list-item)'>
       
            <ul>
              <xsl:call-template name='show-institutions'>
                <xsl:with-param name='list' select='$found-items'/>
                <xsl:with-param name='mode' select='"add"'/>
              </xsl:call-template>
            </ul>

          </xsl:if>
     
        </xsl:if>
  
        <form xsl:use-attribute-sets='form'>
          <p>
            <input type='submit' name='action' value='continue' /> &#160;
              or <a href='{$base-url}/{$session-type}/new-institution!{$session-id}' 
              >submit an institution info</a>.
          </p>
        </form>
        
      </xsl:variable>      

      <xsl:choose>
        <xsl:when test='$user-login and $session-type="user"'>

          <xsl:call-template name='registered-user-page'>
            <xsl:with-param name='title'>affiliation profile</xsl:with-param>
            <xsl:with-param name='content'>
              <xsl:copy-of select='$content'/>
            </xsl:with-param>
          </xsl:call-template>
          
        </xsl:when>
        <xsl:otherwise>
          
          <xsl:call-template name='page'>
            <xsl:with-param name='title'>affiliation profile</xsl:with-param>
            <xsl:with-param name='content'>
              <xsl:copy-of select='$content'/>
            </xsl:with-param>
          </xsl:call-template>
          
        </xsl:otherwise>
      </xsl:choose>

    </xsl:template>
    
</xsl:stylesheet>