<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">
 
  <xsl:output
    method='text'
    encoding='utf-8'/>


<!-- GLOBAL VARIABLES  --> 

<!-- main ones -->
 
<xsl:variable name='root'       select='/'/>
<xsl:variable name='session'    select='/data/session'/>
<xsl:variable name='config'     select='/data/config'/>
<xsl:variable name='variables'  select='/data/variables'/>

<xsl:variable name='request'    select='$variables/request'/>


<!-- configuration -->

<xsl:variable name='base-url'    select='$config/base-url/text()'/>
<xsl:variable name='site-name'   select='$config/site-name/text()'/>
<xsl:variable name='help-url'    select='$config/help-url/text()'/>
<xsl:variable name='admin-email' select='$config/admin-email/text()'/>
<xsl:variable name='debug-mode'  select='$config/debug/text()'/>

<!-- request parts -->

<xsl:variable name='request-user'       select='$request/user'/>

<!-- request context and details -->

<xsl:variable name='session-id'   select='$session/id/text()'  />
<xsl:variable name='session-type' select='$session/type/text()'/>
<xsl:variable name='session-owner' select='$session/owner'/>

<xsl:variable name='user-data'    select='$session/user-data'/>

<xsl:variable name='user-name'    select='$user-data/owner/name/text()'/>
<xsl:variable name='user-login'   select='$user-data/owner/login/text()'/>
<xsl:variable name='user-type'    select='$user-data/owner/type/text()'/>


<xsl:variable name='response-data' select='$variables/response/data'/>



<!-- this template-specific variables: -->

<xsl:variable name='confirmation-url' select='$response-data/confirmation-url/text()'/>


<xsl:template match='/data'
>From: <xsl:value-of select='$config/email-from'/>
To: "<xsl:value-of select='$user-name'/>" &lt;<xsl:value-of select='$user-login'/>&gt;
Subject: registration at <xsl:value-of select='$site-name'/>: confirm

Hello <xsl:value-of select='$user-name'/>.

Please confirm your registration in ACIS at <xsl:value-of select='$site-name'/>:

<xsl:value-of select='$confirmation-url'/>


All the details are at:

<xsl:value-of select='$base-url'/>

</xsl:template>




</xsl:stylesheet>

