use strict; # -*-perl-*-
use warnings;

BEGIN { 
      eval "use ReDIF::Record;";
      if ( $@ ) {
         print "1..0 # Skipped: ReDIF-perl is not installed\n";
	 exit;
      }
}

use AMF::Tests;


eval "use AMF::2ReDIF;";
test not $@;

use AMF::Parser;
use Data::Dumper;

sub open_get ($);

my $t = open_get 't/1993-12.xml';
test $t;
print Dumper( $t );


test $t = open_get 'testsuite/6.xml';
print Dumper( $t );


test $t = open_get 't/2002-27.xml';
print Dumper( $t );

test scalar $t -> get_value( 'author/name' );
my @au = $t -> get_value( 'author/name' );
test $au[0] eq "Rodenburg, C.A.";

test $t->get_value( 'title' );
my $ti = ($t->get_value( 'title' ))[0];
test $ti =~ /comparative framework /, $ti;


$t = open_get 't/paul_storer.xml';
test $t;
print Dumper( $t );



sub open_get ($) { 
  my $file = shift;
  
  my $rec;
  if ( amf_open_file( $file ) ) {
    my $r = amf_get_next_record;                
    if ( $r ) {                 
      return AMF::2ReDIF::translate( $r );
    }
  }
  return undef;
}

