
use AMF::Spec

func noun AMF::Spec::define_noun
func type AMF::Spec::define_type

func structure AMF::Spec::structure
func dumpspec AMF::Spec::dump_spec
func verb AMF::Spec::verb
func verbpair AMF::Spec::verbpair
func namespace AMF::Spec::namespace

func default-namespace AMF::Spec::default_namespace

func depend AMF::Spec::depend


namespace amf "http://amf.openlib.org"
namespace xml "http://www.w3.org/XML/1998/namespace"
namespace xsi "http://www.w3.org/2001/XMLSchema-instance"

default-namespace amf


noun person type p/o

noun organization type p/o

noun text  type dctype:text

noun collection  type dctype:collection


type p/o
  structure

   adj name	  type vCard:FN
   adj shortname  type vCard:NickName
   adj familyname type vCard:N;FamilyName
   adj givenname  type vCard:N;GivenName
   adj additionalname type vCard:N;AdditionalName
   adj nameprefix type vCard:N;HonoraryPrefix
   adj namesuffix type vCard:N;HonorarySuffix

   adj date       type event_date
   adj homepage   type URL
   adj postal     #type vCard:LABEL
   adj phone      #type "vCard:TEL;TYPE=pref,voice"
   adj fax        
   adj email      type EMAIL
   adj identifier type dc:identifier

   ### XXX the following group of verbs is under a question, the to... part
   verb isreplacedby   
       to person organization
   verb replaces
       to person organization
   verb ispartof	
       to person organization
   verb haspart
       to person organization


   verb isauthorof 
       to text
   verb iseditorof
       to text collection
   verb ispublisherof
       to text collection
   verb istranslatorof
       to text
   verb ismaintainerof
       to text collection

### --- ZZZ 



type dctype:text
   structure

    adj title
    adj abstract
    adj keywords
    adj classification type classification
    adj copyright
    adj status

    adj comment
    adj email        type EMAIL
    adj date         type event_date
    adj displaypage  type URL

    adj citation


    adjcontainer serial    type serial-container
    adjcontainer file      type file-container
    adjcontainer reference type reference-container
   

    adj type type text_type
    adj identifier

    verb hasauthor haseditor haspublisher hassuperviser hastranslator hasmaintainer
      to person organization

    verb iserratumof haserratum isaddenumof hasaddenum isreviewof hasreview 
      to text

    verb iscommenton hascomment istranslationof hastranslation 
      to text

    verb replaces isreplacedby haspart isreferencedby references 
      to text

    verb isversionof hasversion isformatof hasformat
      to text

    verb ispartof 
      to text collection



type file-container
  structure
    adj url type URL
    adj function 
    adj format type dc:format
    adj restriction type dc:rights


type serial-container
  structure
    adj journaltitle
    adj journalabbreviatedtitle # type 
    adj journalidentifier # type 
    adj issuedate type DATE
    adj volume # type 
    adj part
    adj issue
    adj season
    adj quarter
    adj startpage
    adj endpage

    adj pages
    adj articlenumber


type reference-container
  structure
    adj literal
    adj context



type dctype:collection
   structure
     adj title
     adj abbreviatedtitle
     adj description
     adj homepage
     adj accesspoint
     adj type type collection_type
     adj identifier

     verb isreplacedby replaces ispartof
       to collection

     verb haspart
       to collection text

     verb haseditor haspublisher hasmaintainer
       to person organization




verbpair hasauthor      isauthorof
verbpair haseditor      iseditorof
verbpair hasmaintainer  ismaintainerof

verbpair istranslatorof hastranslator

verbpair ispublisherof  haspublisher
verbpair isreferencedby references

verbpair hassuperviser  issuperviserof

verbpair hasversion	isversionof
verbpair replaces	isreplacedby
verbpair haspart	ispartof
verbpair hastranslation istranslationof
verbpair hasformat	isformatof
verbpair hascomment	iscommenton
verbpair haserratum	iserratumof
verbpair hasaddenum	isaddenumof
verbpair hasreview	isreviewof



type human_name
  text
    re "^(\\w+[\\d\\-\\,\\.\\s\\w]*)$"
    length min 3

type collection_type
  text 
    variants book proceedings journal classification serial archive 

type text_type
  text
    variants book conferencepaper article preprint bookitem 


depend ReDIF::URL_Syntax 

type URL
  text
    function ReDIF::URL_Syntax::check_url


type EMAIL   # copied from redif.spec
  text   
    re (?i)^([\&\+a-z\d\-\.\=\_]+\@[a-z\d\-\.\=\_]+\.[a-z\d\.\-\=]+)$

type DATE
  text   
    re ^(\d{4}(?:-\d{2}(?:-\d{2})?)?)$


depend AMF::Parser::Datatypes

type classification:jel1991
  text
    function AMF::Parser::Datatypes::jel1991

type dc:format
  text
    function AMF::Parser::Datatypes::mime_type



type event_date
  element
    attribute event type EVENT
    value type DATE

type EVENT
  text
    variants created modified available issued


type URI
  text #    scheme          authority path    query       fragment
    re ^((?:[^:/?#]+:)?(?://[^/?#]*)?[^?#]*(?:\?[^#]*)?(?:#.*)?)$

type absoluteURI
  text #    sheme                   hier_part net_path         | abs_path query      opaque_part fragment
    re ^((?:[a-zA-Z][a-zA-Z\d+.-]*:)(?:(?://[^/?#]*(?:/[^#?]*)?|/[^#?]*)(?:\?[^#]*)?|[^/].*)(?:#.*)?)$




###
### used directly from Contexts.pm
###
type XML_NAME
  text   
    re ^([\pL:_][\pL\d\._:\-]*)$



# dumpspec


# Q1: shall verbs have type?
# Q2: shall each instance of a verb mention a type?
# Q3

#verb to-replace
#  direct replaces
#  back isreplacedby
#  from 
#     p/o
#  to   
#     p/o

#verb to-have-part
#  direct haspart
#  back ispartof

#  from 
#     type p/o 
#  to 
#     type p/o
#  from   
#     type text
#  to 
#     type text
#     type collection

#  from      
#     type collection
#  to
#     type collection

#type isreplacedby
#  maycontain person
#  maycontain organization
#  reverse replaces

#type isreplacedby
#  maycontain person
#  maycontain organization
#  reverse replaces

