use AMF::Tests;

use AMF::Parser;
test not $@;

$AMF::Parser::parser -> {REPORT_ENCLOSED_NOUNS} = 1;

my $res = amf_open_file( 'testsuite/4.xml' );
test $res;


my $slofi;
my @recs;

while ( 1 ) {
  my $r = amf_get_next_record();

  if ( $r ) {
    print "record: ", $r->id, "\n";
    
    use Data::Dumper;
    print Dumper( $r );

    if ( $r->id eq 'amf:slofi' ) {
      $slofi = $r;
    }
    push @recs, $r;

  } else {
    last;
  }
}

test $recs[0]->id eq 'amf:slofi';
test $recs[1]->id eq 'amf:JSB';

my @aus = $slofi ->get_value( 'hasauthor/name' );

test scalar @aus;

###  Wrongly assumed
###  http://acis.openlib.org/other/amf/interpret/#q1.1
###  option 1

# test scalar @aus == 2;
# test $aus[0] eq 'John Seely Brown';
# test $aus[1] eq 'Paul Duguid';

###  Now expect option 3:

test scalar @aus == 1;

test $aus[0] eq 'Paul Duguid';


__END__


