package AMF::Parser::Context::ForeignEl;


use AMF::Parser::Basic;
use strict;
use Carp::Assert;

use vars qw( @ISA );
@ISA = qw( AMF::Parser::Context );


sub init {
  my $self = shift;
  my $type = shift;
  my $name = shift;
  my $ns   = shift;

  $self -> SUPER::init( $name );
  $self -> {NS} = $ns;

  $self -> {content} = [];
}

sub text {
  my $self = shift;
  my $text = shift;

  my $cont = $self->{content};
  push @$cont, $text;
}


sub element {
  my $self = shift;
  my $name = shift;
  my $ns   = shift;
  open_context( 'ForeignEl', '', $name, $ns );
  
  return;
}

sub child {
  my $self = shift;
  my $type = shift;  ## shall be "ForeignEl"
  assert( $type eq 'ForeignEl' );

  my @content = @_;

  my $cont = $self->{content};
  push @$cont, [ @content ];
}


sub end_tag {
  my $self = shift;

  my $ns   = $self ->{NS} || '';
  my $name = $self ->{NAME};

  debug "Foreign element: finished ('$ns $name')";

  close_context( 'ForeignEl', "$ns $name", 
                 $self ->{ATTR},
                 $self ->{content} );

}


1;
