use ReDIF::Writer;

use Test;

BEGIN{  plan tests => 6; }

ok( 1 );

#use Data::Dumper;
#print Dumper( $ReDIF::Writer::spec );
#die;

my $template = {
    'template-type' => [ 'ReDIF-Paper 1.0' ],
    'handle'        => [ 'RePEc:wop:aarhec:some_asdf' ],
    'creation-date' => [ '1999-08-12', ],
    'revision-date' => [ '1999-08-13', '2001' ],
    'title'	    => [ 'A testing paper template' ],
    'file'  => [ { url => ['http://ff.ggr.com/'] } ],
    'author' => 
    [
     { name => [ 'Edik Burilkin', 'f' ],
       person => [ 'RePEc:per:1933-03-03:EDIK_BURILKIN' ],
       workplace =>
       [
        {
         name => ['Kurchatov Institut'],
         institution => [ 'RePEc:edi:kurchru' ],
        },
        {
         name => ['Berkley'],
         institution => ['RePEc:edi:berklus'],
        }
       ]
       },

     { name => [ 'Burik Doilkin' ],
       person => [ 'RePEc:per:1933-03-03:BURIK_DOILKIN'],
       workplace =>
       [
        {
         name => ['RTI'],
         institution => ['RePEc:edi:mrtidby'],
        }
       ]
       },
    ]

  };

my ( $string ) = ReDIF::Writer::stringify_template( $template ) ;

ok( 2 );

print $string;

ok( $string =~ /\nauthor\-workplace\-institution: RePEc:edi:berklus\n/i );
ok( $string !~ /ARRAY/ );
ok( $string !~ /HASH/ );
ok( $string =~ /\nauthor-name: Burik Doilkin\n/i );
