
### -*- Mode: perl -*-

eval " use ReDIF::Lite; ";

test( not( $@ ), $@ );

use ReDIF::Lite qw( &redif_open_file 
		    &redif_get_next_template 
		    &redif_get_next_template_good_or_bad 
		    );

my $r;
my $t;

$r = redif_open_file( 't/test.rdf' );

test ( $r ) ;

$t = redif_get_next_template();

test( $t );

test( $t->{'FILENAME'} );


$r = redif_open_file( 't/names_test.rdf' );
$t = redif_get_next_template();

test( $t );
test( ref $t eq 'HASH' );
test( ref $t->{author} eq 'ARRAY' );

use Data::Dumper;

#print "template: " , Dumper( $t ) , "\n";

my $authors = $t->{author};

test( scalar( @$authors ) == 2 );

my $h = $t->{handle};


print "handle: " , Dumper( $h ) , "\n";


test( (scalar( @$h ) == 1 ) , $h->[0] );

test( $h->[0] );

my $tt = $t->{'template-type'};

test( (scalar( @$tt ) == 1 ) , $tt->[0] );


###  1995-lite.rdf test data file

$r = redif_open_file( 't/1995-lite.rdf' );


###  getting first template
$t = redif_get_next_template_good_or_bad();

test( $t, 'first template' );
test( ref $t eq 'HASH' );
test(     $t->{RESULT} eq 'good' );

# print "template [1]: " , Dumper( $t ) , "\n";


###  getting second template
$t = redif_get_next_template_good_or_bad();

print "template [2]: " , Dumper( $t ) , "\n";

test(     $t, '2nd template' );
test( ref $t eq 'HASH' );
test(     $t->{RESULT} eq 'good'               );
test( ref $t->{'unknown-attribute'} eq 'ARRAY' );
test(     $t->{'unknown-attribute'} [0]        );


###  getting third template
$t = redif_get_next_template_good_or_bad();

print "template [3]: " , Dumper( $t ) , "\n";

test(     $t, '3rd template' );
test( ref $t eq 'HASH' );
test(     $t->{RESULT} eq 'good'                 );
test( ref $t->{author}[1]{additional} eq 'ARRAY' );
test(     $t->{author}[1]{additional} [0]        );


###  getting forth template 
$t = redif_get_next_template_good_or_bad();

print "template [4]: " , Dumper( $t ) , "\n";

test(     $t, '4th template' );
test( ref $t eq 'HASH' );
test(     $t->{RESULT} eq 'good'              );
test( ref $t->{'new-attribute'} eq 'ARRAY'    );
test(     $t->{'new-attribute'} [0]           );
test( ref $t->{author}[0]{unknown} eq 'ARRAY' );
test(     $t->{author}[0]{unknown} [0]        );



###############################################################
#############     TESTING   FRAMEWORK     #####################
###############################################################

sub test {
    push @TESTS, shift;
    push @MESSAGES, shift;
}

sub ok { 
    push @TESTS, 1; 
    push @MESSAGES, shift;
}
sub nok { 
    push @TESTS, 0; 
    push @MESSAGES, shift;
}



END { 

    my $tests = scalar @TESTS;

    if( not $tests ) {
	print "1..1\nnot ok 1\n";
	exit;
    }

    print "1..$tests\n";

    my $counter = 1;
    while ( 1 ) {
	my $t = shift @TESTS;
	my $m = shift @MESSAGES;
	if( not $t ) {
	    print "not ";
	}
	print "ok $counter\n";

	if( $m ) { 
	    print "[$counter] $m\n";
	}
	last if not scalar @TESTS;
	$counter ++;
    }
}

