#####################################################################
############     open ReDIF Specification File     ##################
#####################################################################

version = $Revision$

###  $Id $

# Brief history since 2000
#
# version revised by Thomas Krichel in July 2000
# 
# Book and Chapter templates added by Ivan Kurmanov, Jul 2001
#


#  NEW ATTRIBUTE SPECIFICATION LINE FORMAT:
# 
#      attribute[:[type[:subtype]],qualifier[,qualifier[...]] 
# 
#   where qualifier is one of 
#
#    'req' or 'required'  -- the attribute is required, must appear
#                            at least once
#    'norep' or 'nonrep' or 'nonrepeatable' -- the attribute cannot
#                                              be repeated, can appear
#                                              no more that once
#    'key' -- specifies key attribute of a cluster (the attribute that
#             the cluster must begin with).  Implies: required, 
#             nonrepeatable
#
#   NOTE: specification line is letter case and whitespace insignificant
#  

#   OLD ATTRIBUTE SPECIFICATION LINE FORMAT (still accepted):
#
# attribute_name[:[type][:[subtype][:[required flag][:[repeatable flag]]]]]
#


###
### User-defined types (checking procedures)
###


type = programming_language / check-regex {
 ^(?:stata|Mathematica|RATS|GAUSS|MATLAB|FORTRAN|C|Ox|perl|C\+\+|python|Octave|Shazm|executable)$
}


###  The following defines a datatype "MIME_type" through
###  preproc-essing aspect.  The following code is executed
###  (eval-uated) each time a value ($value) of type MIME_type has
###  just been read from a datafile.

type = MIME_type / check-eval {

    ### strip everything after the second slash
    $value =~ s!(^[^/]+/[^/]+)/.*!$1!;  

#    ### save the value 
#    my $v = $value;           

#    ### try loading the types list module

    eval { require( ReDIF::MIME_types ) }; 
    my $error = $@;

    if ($error) { 
	warn "can't load ReDIF::MIME_types module";
	return undef;
    };

#    msg( "MIME types badly loaded", 3 ) 
#          if not $ReDIF::MIME_types::LIST{'application/pdf'};

    my $ok = 0;

    ### check the MIME type
    if ( $ReDIF::MIME_types::LIST{$value} ) { 
      $ok = 1;
    } else {
      if( $value =~ /[A-Z]/ ) {
	$value = lc $value;
        if ( $ReDIF::MIME_types::LIST{ $value } ) {   
          $ok  = 1;
    } } }

    if ( not $ok ) {   
	error( "Invalid MIME-type used: '$value'" ) ;
    };

    return 1;
}


##
## Handles checking regular expression 
##
type = handle / check-regex {
^[A-Za-z]+\:[a-zA-Z]+(?:\:[a-zA-Z0-9]+(?:\:[^\s\n]+)?)?$
}

##
## 
##
type = archivehandle / check-eval {
    $value =~ tr/A-Z/a-z/;
    $value =~ s/^RePEc/RePEc/i;
    $value =~ s/^ReLIS/ReLIS/i;
    if( $value =~ m/^(?:RePEc|ReLIS|mapin):[a-zA-Z]{3}$/i ) 
    { return 1; } else { return 0; } 
}

# documenthandle to be used for paper, article and software
type = documenthandle / check-eval {
    $value =~ tr/A-Z/a-z/;
    $value =~ s/^RePEc/RePEc/i;
    $value =~ s/^ReLIS/ReLIS/i;
    if( $value =~ 
   m/^(?:RePEc|ReLIS|mapin):[a-z]{3}:[a-z\d]{6}:[\da-z\_\-\:\.\/\\]+$/i ) 
    { return 1; } else { return 0; }    
}

#
type = institutionhandle / check-eval {
    $value =~ tr/A-Z/a-z/;
    $value =~ s/^RePEc/RePEc/i;
    $value =~ s/^ReLIS/ReLIS/i;
    if( $value =~ m/^(?:RePEc|ReLIS|mapin):[a-z]{3}:[a-z\d]{7}$/i ) 
     { return 1; } else { return 0; }
}


type = personhandle / check-eval {
    $value =~ tr/A-Z/a-z/;
    $value =~ s/^RePEc/RePEc/i;
    $value =~ s/^ReLIS/ReLIS/i;
    if( $value =~ m/^(?:RePEc|ReLIS|mapin):[a-z]{3}:\d{4}-[01]\d-[0-3]\d:[a-z\_\.\-]+$/i ) 
    { return 1; } else { return 0; }
}


type = serieshandle / check-eval {
    $value =~ tr/A-Z/a-z/;
    $value =~ s/^RePEc/RePEc/i;
    $value =~ s/^ReLIS/ReLIS/i;
    if( $value =~ m/^(?:RePEc|ReLIS|mapin):[a-z]{3}:[a-z\d]{6}$/i ) 
    {  return 1; } else { return 0; }
}


##
## all non-handle types, ordered alphabetically 
##

type = date / check-eval {
     if ($value !~ /-/ ) {
        $value =~ s/^(\d{4})(\d{2})$/$1-$2/;
        $value =~ s/^(\d{4})(\d{2})(\d{2})/$1-$2-$3/; }

     return 1 if $value =~ /^\d{4}(-\d\d){0,2}$/;
     return 0;
}

type = email / check-regex {
^[\+a-z\d\-\.\=\_]+\@[a-z\d\-\.\=\_]+\.[a-z\d\.\-\=]+$
}


### this is now obsolete

type = fileformat / check-regex {
^(?:\w+)(?:/\w+)?$
}

type = JEL / check-eval {

     if ( $value !~ /[a-z][\d]{0,3}/i ){ return undef; }

     if ( not require ReDIF::JELcodes )   {
         warn "can't load JEL codes perl module";
	 return undef;     }

     my $v = uc $value ;
     my @J = split ( /[,;:\s\.]+/, $v );

     $value = '';
     my $J;
     foreach $J (@J) {
       	if( $J =~ /^([A-Z])0{2}$/ ) {
	  $J = $1;
       	} elsif( $J =~ /^([A-Z]\d{2})0$/ ) {
	  $J = $1;
	;}
        if (exists $JELcodes::JEL{$J}) {
           $value .= $J;
           $value .= ' ';
        } else {
	   error( "An invalid JEL code used '$J'" );
     } }
     chop $value; return length $value;
}

# publication status type implements Sune's requirement that the
# first word in the publication status should be either "published" or
# "forthcoming"
type = pubstat / check-regex  {
 ^(?:forthcoming|published)
}


# URL datatype

type = URL / check-eval {
     if ($value =~ /\-\ [^\ \n]/ ) {
     error ( "A whitespace character in an URL after a dash" ) ; }
     $value =~ s/\s+|\n+//g;

 if ( ($value =~ /^(?:ftp|http):\/\//i) 
    and ($value !~ /^(?:ftp|http):\/\//) ) {
#        msg "($file, $line): URL capitalization is bad \"$value\"", 2;
        $value =~ s/^Ftp/ftp/i;
        $value =~ s/^Http/http/i;
        ;}
 if( $value =~ /^(?:URL:)?
 (?:ftp|http|gopher)\:
 \/\/[^\=\;\/\#\?\:\ \{\}\|\[\]\\\^\~\<\>]+
 (?:\:[0-9]+)?
 (?:\/
 (?:[^\=\;\#\?\:\ \{\}\|\[\]\\\^\<\>]+)?
 (?:\?[^\;\#\?\:\ \{\}\|\[\]\\\^\~\<\>]*)?
 (?:\#[^\;\#\?\:\ \{\}\|\[\]\\\^\~\<\>]*)?
 )?$/x ) { return 1; }
 else { return 0; }
}



###  The following have been used for UPS proto-proto:

###  (in conjunction with ReDIF/math_class_msc1991.pm file it provides
###  checking for the mathematics classification codes of MSC1991 system)

type = MSC1991 / check-eval {

     my $v = uc $value ;
     my @C = split ( /[,;:\s\.]+/, $v );

     eval { require ReDIF::math_class_msc1991 };
     my $error = $@;

     if ( $error ) {
        warn "can't load ReDIF/math_class_msc1991.pm file";    
	return undef;
     };

     $value = '';
     my $C;
     foreach $C (@C) {
          if (exists $msc1991{$C}) {
             $value .= $C;
             $value .= ' ';
          } else {
             error( "An invalid MSC1991 code used: '$C'" );    
     } }
     chop $value; return length $value;
}




###
### Cluster definitions
###

###  File cluster definition:  (now with file-format attribute of MIME type)

cluster=File {
        URL:URL, key
        Format:MIME_type
        Restriction
        Function, nonrep
        Size
}


postproc=File {

    warn "file cluster postprocessing";

}


Cluster=Organization {
        Name, key
        Name-English
        Location
        Postal
        Email
        Phone
        Fax
        Homepage:URL
        Institution:institutionhandle, nonrep
}

Cluster=Person {
        Name, key
        WorkPlace:cluster:Organization
        Email
        Fax
        Postal
        Phone
        Homepage:URL
        Person:personhandle, nonrepeatable
}

###
### Template-types definition 
###

##
## Collection templates
##

template=ReDIF-Archive 1.0 {
        Template-Type, key
        Name, required
        URL:URL, required
        Homepage:URL
        Description
        Maintainer-Email:email, required
        Maintainer-Name
        Maintainer-Fax
        Maintainer-Phone
        Access-policy
        Restriction
        Classification-Jel:JEL
        Handle:archivehandle, required, nonrepeatable
}


template=ReDIF-Series 1.0 {
        Template-Type, key
        Name, required
        Description
        Classification-Jel:JEL
        Classification-ILA
        Keywords
        type:doctype
        Editor:cluster:Person
        Publisher:cluster:organization
        Order-Postal
        Order-Homepage:URL
        Order-Email:email
        Provider:cluster:organization
        Provider-Institution:institutionhandle
        Maintainer-Email:email, required
        Maintainer-Name
        Maintainer-Fax
        Maintainer-Phone
        Type
        Restriction
        ISSN
        Notification
        Price
        Handle:serieshandle, required, nonrepeatable
}

##
## Resource templates
##

template=ReDIF-Article 1.0 {
        Template-Type, key
        Author:cluster:Person, required
        Title, required, nonrepeatable
        Abstract
        File:cluster:file
        Classification-Jel:JEL
        Keywords
        Keywords-Attent
        Creation-Date:date, nonrep
        Journal
        Issue
        Year
        Pages
        Volume
        Month
        Number
        Note
        Publication-Status:pubstat
        Publication-Date:date
        Order-URL:URL
        Paper-Handle:documenthandle
        Book-Handle:documenthandle
        Chapter-Handle:documenthandle
        Software-Handle:documenthandle
        Handle:documenthandle, required, nonrep
}

template=ReDIF-Paper 1.0 {
        Template-Type, key
        Author:cluster:Person, required
        Title, req, nonrep
        Abstract
        File:cluster:file
        Classification-Jel:jel
	Classification-arxiv
	Classification-acm-1998
	Classification-msc-1991:MSC1991
	Classification-xxx

        Keywords
        Keywords-Attent
	Keywords-cogprints
	comments-paper
        Note
        Length
        Series
        Number
        Contact-Email:email, nonrep
        Availability
        Creation-Date:date, nonrep
        Revision-Date:date
        Restriction
        Price
        Publication-Status:pubstat
        Issue
        Order-URL:URL
        Article-Handle:documenthandle
        Software-Handle:documenthandle
        Book-Handle:documenthandle
        Chapter-Handle:documenthandle
        Handle:documenthandle, req, nonrep
}

postproc=ReDIF-Paper 1.0 {

    error "Is that a good paper?";
#    warning "Is that a good paper?";
}


template=ReDIF-Software 1.0 {
        Template-Type, key
        Author:cluster:Person, req
        Title, req, nonrep
        Abstract
        File:cluster:file
        Keywords
        Size
        Requires
        Note
        Length
        Series
        Number
        Creation-Date:date, nonrep
        Revision-Date:date
        Price
        Programming-Language:programming_language::

        Classification-Jel:jel, nonrep

        Publication-Status:pubstat

        Article-Handle:documenthandle
        Paper-Handle:documenthandle
        Book-Handle:documenthandle
        Chapter-Handle:documenthandle
        Handle:documenthandle, required,nonrep
}

##
##  New resource templates: book and chapter
##

template=ReDIF-Book 1.0 {
        Template-Type, key

        Handle:documenthandle, required, nonrep

        Author:cluster:Person, required
        Title, required, nonrepeatable
        Abstract
	Publisher:cluster:Organization, required

        Year,   nonrep
        Month,  nonrep
        Volume, nonrep

        Edition, nonrep
        Series, nonrep
	Editor:cluster:Person
	ISBN,   nonrep

        Publication-Status:pubstat
        Note

        Classification-Jel:jel
	Classification-arxiv
	Classification-acm-1998

	Classification-msc-1991:MSC1991
	Classification-xxx

        Keywords
        Keywords-Attent

	HasChapter:documenthandle
	
	Paper-handle:documenthandle
	Article-handle:documenthandle
	Chapter-handle:documenthandle

}


template=ReDIF-Chapter 1.0 {
        Template-Type, key

        Handle:documenthandle, req, nonrep

        Author:cluster:Person, req

        Title, req, nonrep
        Abstract

#	Publisher:cluster:Organization:1

###   at least one of the two is required, 
###   but that is not expressible in redif.spec:

	Provider:cluster:Organization
	Sponsor:cluster:Organization

	Book-Title, req, nonrep

	Pages, nonrep
        Year, nonrep
        Month, nonrep
        Volume, nonrep
	Chapter, nonrep

        Edition, nonrep
        Series, nonrep
	Editor:cluster:Person, required
	ISBN, nonrep

        Publication-Status:pubstat
        Note


        Classification-Jel:jel, nonrep
	Classification-arxiv, nonrep
	Classification-acm-1998, nonrep
	Classification-msc-1991:MSC1991, nonrep
	Classification-xxx, nonrep

        Keywords, nonrep
        Keywords-Attent, nonrep

	In-Book:documenthandle, nonrep
	
	Paper-handle:documenthandle
	Article-handle:documenthandle
#	Chapter-handle:documenthandle
#	Book-handle:documenthandle

}





##
## Tangibles template-types
##

template=ReDIF-Institution 1.0 {
        Template-Type, key
        Primary:cluster:organization
        Primary-Area
        Secondary:cluster:organization
        Secondary-Area
        Tertiary:cluster:organization
        Tertiary-Area
        Handle:institutionhandle, required, nonrepeatable

	Primary-Defunct
	Secondary-Defunct
	Tertiary-Defunct

}

template=ReDIF-Person 1.0 {
        Template-Type, key
        Name-Full, req
        Name-First
        Name-Last
        Email
        Fax
        Postal
        Phone
        Homepage:URL
        Classification-Jel
        WorkPlace:cluster:Organization
	Workplace-Institution:institutionhandle
	Author-Paper:documenthandle
	Author-Article:documenthandle
	Author-Software:documenthandle
	Editor-Series:serieshandle
        Handle:personhandle, req, nonrep
}



record-type = open-record-type {
  !START: record: type
  !END:   record: end

}



