
package ReDIF::JELcodes;

# $Id$
# $VERSION = do { my @r=(q$Revision$=~/\d+/g); sprintf "%d."."%02d"x$#r,@r }; 


##########################################
#
# List of JEL codes used for texts clasifications.
# http://www.aeaweb.org/journal/jel_class_system.html
# 
# some items come from historic sources at:
#
#    http://www.econlit.org/elclasjn.htm
#
#    http://www.econlit.org/subject_descriptors.html
#    (19 Jan 2005)
#
##########################################

%JEL = (

 'A' => "General Economics and Teaching",
 'A0' => "General Economics and Teaching: General",
 'A00' => "General",
 'A1' => "General Economics",
 'A10' => "General",
 'A11' => "Role of Economics; Role of Economists; Market for Economists",
 'A12' => "Relation of Economics to Other Disciplines",
 'A13' => "Relation of Economics to Social Values",
 'A14' => "Sociology of Economics",
 'A19' => "Other",
 'A2' => "Economics Education and Teaching of Economics",
 'A20' => "General",
 'A21' => "Pre-college",
 'A22' => "Undergraduate",
 'A23' => "Graduate",
 'A29' => "Other",
 'A3' => "Multisubject Collective Works",
 'A30' => "General",
 'A31' => "Multisubject Collected Writings of Individuals",
 'A32' => "Multisubject Volumes",
 'A39' => "Other",
 'B' => "Schools of Economic Thought and Methodology",
 'B0' => "General",
 'B00' => "General",
 'B1' => "History of Economic Thought through 1925",
 'B10' => "General",
 'B11' => "Preclassical",
 'B12' => "Classical",
 'B13' => "Neoclassical through 1925",
 'B14' => "Socialist; Marxist",
 'B15' => "Historical; Institutional",
 'B16' => "History of Economic Thought: Quantitative and Mathematical",
 'B19' => "Other",
 'B2' => "History of Economic Thought since 1925",
 'B20' => "General",
 'B21' => "Microeconomics",
 'B22' => "Macroeconomics",
 'B23' => "History of Economic Thought: Econometrics; Quantitative and Mathematical Studies",
 'B24' => "Socialist; Marxist; Sraffian",
 'B25' => "Historical; Institutional; Evolutionary; Austrian",
 'B29' => "Other",
 'B3' => "History of Thought:  Individuals",
 'B30' => "General",
 'B31' => "Individuals",
 'B32' => "Obituaries",
 'B4' => "Economic Methodology",
 'B40' => "General",
 'B41' => "Economic Methodology",
 'B49' => "Other",
 'B5' => "Current Heterodox Approaches",
 'B50' => "General",
 'B51' => "Socialist; Marxian; Sraffian",
 'B52' => "Institutional; Evolutionary",
 'B53' => "Austrian",
 'B54' => "Feminist Economics",
 'B59' => "Other",
 'C' => "Mathematical and Quantitative Methods",
 'C0' => "General",
 'C00' => "General",
 'C01' => "Econometrics",
 'C02' => "Mathematical Methods",
 'C1' => "Econometric and Statistical Methods:  General",
 'C10' => "General",
 'C11' => "Bayesian Analysis",
 'C12' => "Hypothesis Testing",
 'C13' => "Estimation",
 'C14' => "Semiparametric and Nonparametric Methods",
 'C15' => "Simulation Methods",
 'C16' => "Specific Distributions",
 'C19' => "Other",
 'C2' => "Single Equation Models; Single Variables",
 'C20' => "General",
 'C21' => "Cross-Sectional Models; Spatial Models; Treatment Effect Models",
 'C22' => "Time-Series Models",
 'C23' => "Models with Panel Data",
 'C24' => "Truncated and Censored Models",
 'C25' => "Discrete Regression and Qualitative Choice Models",
 'C29' => "Other",
 'C3' => "Multiple or Simultaneous Equation Models",
 'C30' => "General",
 'C31' => "Cross-Sectional Models; Spatial Models; Treatment Effect Models",
 'C32' => "Time-Series Models",
 'C33' => "Models with Panel Data",
 'C34' => "Truncated and Censored Models",
 'C35' => "Discrete Regression and Qualitative Choice Models",
 'C39' => "Other",
 'C4' => "Econometric and Statistical Methods:  Special Topics",
 'C40' => "General",
 'C41' => "Duration Analysis",
 'C42' => "Survey Methods",
 'C43' => "Index Numbers and Aggregation",
 'C44' => "Statistical Decision Theory; Operations Research",
 'C45' => "Neural Networks and Related Topics",
 'C46' => "Specific Distributions",
 'C49' => "Other",
 'C5' => "Econometric Modeling",
 'C50' => "General",
 'C51' => "Model Construction and Estimation",
 'C52' => "Model Evaluation and Selection",
 'C53' => "Forecasting and Other Model Applications",
 'C59' => "Other",
 'C6' => "Mathematical Methods and Programming",
 'C60' => "General",
 'C61' => "Optimization Techniques; Programming Models; Dynamic Analysis",
 'C62' => "Existence and Stability Conditions of Equilibrium",
 'C63' => "Computational Techniques",
 'C65' => "Miscellaneous Mathematical Tools",
 'C67' => "Input-Output Models",
 'C68' => "Computable General Equilibrium Models",
 'C69' => "Other",
 'C7' => "Game Theory and Bargaining Theory",
 'C70' => "General",
 'C71' => "Cooperative Games",
 'C72' => "Noncooperative Games",
 'C73' => "Stochastic and Dynamic Games; Evolutionary Games; Repeated Games",
 'C78' => "Bargaining Theory; Matching Theory",
 'C79' => "Other",
 'C8' => "Data Collection and Data Estimation Methodology; Computer Programs",
 'C80' => "General",
 'C81' => "Microeconomic Data",
 'C82' => "Methodology for Collecting, Estimating, and Organizing Macroeconomic Data",
 'C87' => "Econometric Software",
 'C88' => "Other Computer Software",
 'C89' => "Other",
 'C9' => "Design of Experiments",
 'C90' => "General",
 'C91' => "Laboratory, Individual Behavior",
 'C92' => "Laboratory, Group Behavior",
 'C93' => "Field Experiments",
 'C99' => "Other",
 'D' => "Microeconomics",
 'D0' => "General",
 'D00' => "General",
 'D01' => "Microeconomic Behavior: Underlying Principles",
 'D02' => "Institutions: Design, Formation, and Operations",
 'D1' => "Household Behavior and Family Economics",
 'D10' => "General",
 'D11' => "Consumer Economics: Theory",
 'D12' => "Consumer Economics: Empirical Analysis",
 'D13' => "Household Production and Intrahousehold Allocation",
 'D14' => "Personal Finance",
 'D18' => "Consumer Protection",
 'D19' => "Other",
 'D2' => "Production and Organizations",
 'D20' => "General",
 'D21' => "Firm Behavior",
 'D23' => "Organizational Behavior; Transaction Costs; Property Rights",
 'D24' => "Production; Cost; Capital and Total Factor Productivity; Capacity",
 'D29' => "Other",
 'D3' => "Distribution",
 'D30' => "General",
 'D31' => "Personal Income, Wealth, and Their Distributions",
 'D33' => "Factor Income Distribution",
 'D39' => "Other",
 'D4' => "Market Structure and Pricing",
 'D40' => "General",
 'D41' => "Perfect Competition",
 'D42' => "Monopoly",
 'D43' => "Oligopoly and Other Forms of Market Imperfection",
 'D44' => "Auctions",
 'D45' => "Rationing; Licensing",
 'D46' => "Value Theory",
 'D49' => "Other",
 'D5' => "General Equilibrium and Disequilibrium",
 'D50' => "General",
 'D51' => "Exchange and Production Economies",
 'D52' => "Incomplete Markets",
 'D53' => "Financial Markets",
 'D57' => "Input-Output Tables and Analysis",
 'D58' => "Computable and Other Applied General Equilibrium Models",
 'D59' => "Other",
 'D6' => "Welfare Economics",
 'D60' => "General",
 'D61' => "Allocative Efficiency; Cost-Benefit Analysis",
 'D62' => "Externalities",
 'D63' => "Equity, Justice, Inequality, and Other Normative Criteria and Measurement",
 'D64' => "Altruism",
 'D69' => "Other",
 'D7' => "Analysis of Collective Decision-Making",
 'D70' => "General",
 'D71' => "Social Choice; Clubs; Committees; Associations",
 'D72' => "Models of Political Processes: Rent-Seeking, Elections, Legislatures, and Voting Behavior",
 'D73' => "Bureaucracy; Administrative Processes in Public Organizations; Corruption",
 'D74' => "Conflict; Conflict Resolution; Alliances",
 'D78' => "Positive Analysis of Policy-Making and Implementation",
 'D79' => "Other",
 'D8' => "Information, Knowledge, and Uncertainty",
 'D80' => "General",
 'D81' => "Criteria for Decision-Making under Risk and Uncertainty",
 'D82' => "Asymmetric and Private Information",
 'D83' => "Search; Learning; Information and Knowledge; Communication; Belief",
 'D84' => "Expectations; Speculations",
 'D85' => "Network Formation and Analysis: Theory",
 'D86' => "Economics of Contract: Theory",
 'D87' => "Neuroeconomics",
 'D89' => "Other",
 'D9' => "Intertemporal Choice and Growth",
 'D90' => "General",
 'D91' => "Intertemporal Consumer Choice; Life Cycle Models and Saving",
 'D92' => "Intertemporal Firm Choice and Growth, Investment, or Financing",
 'D99' => "Other",
 'E' => "Macroeconomics and Monetary Economics",
 'E0' => "General",
 'E00' => "General",
 'E01' => "Measurement and Data on National Income and Product Accounts and Wealth",
 'E1' => "General Aggregative Models",
 'E10' => "General",
 'E11' => "Marxian; Sraffian; Institutional; Evolutionary",
 'E12' => "Keynes; Keynesian; Post-Keynesian",
 'E13' => "Neoclassical",
 'E17' => "Forecasting and Simulation",
 'E19' => "Other",
 'E2' => "Macroeconomics: Consumption, Saving, Production, Employment, and Investment",
 'E20' => "General",
 'E21' => "Consumption; Saving; Wealth",
 'E22' => "Capital; Investment; Capacity",
 'E23' => "Production",
 'E24' => "Employment; Unemployment; Wages; Intergenerational Income Distribution",
 'E25' => "Aggregate Factor Income Distribution",
 'E26' => "Informal Economy; Underground Economy",
 'E27' => "Forecasting and Simulation",
 'E29' => "Other",
 'E3' => "Prices, Business Fluctuations, and Cycles",
 'E30' => "General",
 'E31' => "Price Level; Inflation; Deflation",
 'E32' => "Business Fluctuations; Cycles",
 'E37' => "Forecasting and Simulation",
 'E39' => "Other",
 'E4' => "Money and Interest Rates",
 'E40' => "General",
 'E41' => "Demand for Money",
 'E42' => "Monetary Systems; Standards; Regimes; Government and the Monetary System",
 'E43' => "Determination of Interest Rates; Term Structure of Interest Rates",
 'E44' => "Financial Markets and the Macroeconomy",
 'E47' => "Forecasting and Simulation",
 'E49' => "Other",
 'E5' => "Monetary Policy, Central Banking, and the Supply of Money and Credit",
 'E50' => "General",
 'E51' => "Money Supply; Credit; Money Multipliers",
 'E52' => "Monetary Policy",
 'E53' => "Deposit Insurance",
 'E58' => "Central Banks and Their Policies",
 'E59' => "Other",
 'E6' => "Macroeconomic Policy, Macroeconomic Aspects of Public Finance, and General Outlook",
 'E60' => "General",
 'E61' => "Policy Objectives; Policy Designs and Consistency; Policy Coordination",
 'E62' => "Fiscal Policy",
 'E63' => "Comparative or Joint Analysis of Fiscal and Monetary Policy; Stabilization",
 'E64' => "Incomes Policy; Price Policy",
 'E65' => "Studies of Particular Policy Episodes",
 'E66' => "General Outlook and Conditions",
 'E69' => "Other",
 'F' => "International Economics",
 'F0' => "General",
 'F00' => "General",
 'F01' => "Global Outlook",
 'F02' => "International Economic Order",
 'F1' => "Trade",
 'F10' => "General",
 'F11' => "Neoclassical Models of Trade",
 'F12' => "Models of Trade with Imperfect Competition and Scale Economies",
 'F13' => "Trade Policy; International Trade Organizations",
 'F14' => "Country and Industry Studies of Trade",
 'F15' => "Economic Integration",
 'F16' => "Trade and Labor Market Interactions",
 'F17' => "Trade Forecasting and Simulation",
 'F18' => "Trade and Environment",
 'F19' => "Other",
 'F2' => "International Factor Movements and International Business",
 'F20' => "General",
 'F21' => "International Investment; Long-Term Capital Movements",
 'F22' => "International Migration",
 'F23' => "Multinational Firms; International Business",
 'F24' => "Remittances",
 'F29' => "Other",
 'F3' => "International Finance",
 'F30' => "General",
 'F31' => "Foreign Exchange",
 'F32' => "Current Account Adjustment; Short-Term Capital Movements",
 'F33' => "International Monetary Arrangements and Institutions",
 'F34' => "International Lending and Debt Problems",
 'F35' => "Foreign Aid",
 'F36' => "Financial Aspects of Economic Integration",
 'F37' => "International Finance Forecasting and Simulation",
 'F39' => "Other",
 'F4' => "Macroeconomic Aspects of International Trade and Finance",
 'F40' => "General",
 'F41' => "Open Economy Macroeconomics",
 'F42' => "International Policy Coordination and Transmission",
 'F43' => "Economic Growth of Open Economies",
 'F47' => "Forecasting and Simulation",
 'F49' => "Other",
 'F5' => "International Relations and International Political Economy",
 'F50' => "General",
 'F51' => "International Conflicts; Negotiations; Sanctions",
 'F52' => "National Security; Economic Nationalism",
 'F53' => "International Agreements and Observance; International Organizations",
 'F54' => "Colonialism; Imperialism; Postcolonialism",
 'F59' => "International Relations and International Political Economy: Other",
 'G' => "Financial Economics",
 'G0' => "General",
 'G00' => "General",
 'G1' => "General Financial Markets",
 'G10' => "General",
 'G11' => "Portfolio Choice; Investment Decisions",
 'G12' => "Asset Pricing; Trading volume; Bond Interest Rates",
 'G13' => "Contingent Pricing; Futures Pricing",
 'G14' => "Information and Market Efficiency; Event Studies",
 'G15' => "International Financial Markets",
 'G18' => "Government Policy and Regulation",
 'G19' => "Other",
 'G2' => "Financial Institutions and Services",
 'G20' => "General",
 'G21' => "Banks; Other Depository Institutions; Micro Finance Institutions; Mortgages",
 'G22' => "Insurance; Insurance Companies",
 'G23' => "Pension Funds; Other Private Financial Institutions",
 'G24' => "Investment Banking; Venture Capital; Brokerage; Rating Agencies",
 'G28' => "Government Policy and Regulation",
 'G29' => "Other",
 'G3' => "Corporate Finance and Governance",
 'G30' => "General",
 'G31' => "Capital Budgeting; Fixed Investment and Inventory Studies",
 'G32' => "Financing Policy; Financial Risk and Risk Management; Capital and Ownership Structure",
 'G33' => "Bankruptcy; Liquidation",
 'G34' => "Mergers; Acquisitions; Restructuring; Corporate Governance",
 'G35' => "Payout Policy",
 'G38' => "Government Policy and Regulation",
 'G39' => "Other",
 'H' => "Public Economics",
 'H0' => "General",
 'H00' => "General",
 'H1' => "Structure and Scope of Government",
 'H10' => "General",
 'H11' => "Structure, Scope, and Performance of Government",
 'H19' => "Other",
 'H2' => "Taxation, Subsidies, and Revenue",
 'H20' => "General",
 'H21' => "Efficiency; Optimal Taxation",
 'H22' => "Incidence",
 'H23' => "Externalities; Redistributive Effects; Environmental Taxes and Subsidies",
 'H24' => "Personal Income and Other Nonbusiness Taxes and Subsidies",
 'H25' => "Business Taxes and Subsidies",
 'H26' => "Tax Evasion",
 'H27' => "Other Sources of Revenue",
 'H29' => "Other",
 'H3' => "Fiscal Policies and Behavior of Economic Agents",
 'H30' => "General",
 'H31' => "Household",
 'H32' => "Firm",
 'H39' => "Other",
 'H4' => "Publicly Provided Goods",
 'H40' => "General",
 'H41' => "Public Goods",
 'H42' => "Publicly Provided Private Goods",
 'H43' => "Project Evaluation; Social Discount Rate",
 'H44' => "Publicly Provided Goods: Mixed Markets",
 'H49' => "Other",
 'H5' => "National Government Expenditures and Related Policies",
 'H50' => "General",
 'H51' => "Government Expenditures and Health",
 'H52' => "Government Expenditures and Education",
 'H53' => "Government Expenditures and Welfare Programs",
 'H54' => "Infrastructures; Other Public Investment and Capital Stock",
 'H55' => "Social Security and Public Pensions",
 'H56' => "National Security and War",
 'H57' => "Procurement",
 'H59' => "Other",
 'H6' => "National Budget, Deficit, and Debt",
 'H60' => "General",
 'H61' => "Budget; Budget Systems",
 'H62' => "Deficit; Surplus",
 'H63' => "Debt; Debt Management",
 'H68' => "Forecasts of Budgets, Deficits, and Debt",
 'H69' => "Other",
 'H7' => "State and Local Government; Intergovernmental Relations",
 'H70' => "General",
 'H71' => "State and Local Taxation, Subsidies, and Revenue",
 'H72' => "State and Local Budget and Expenditures",
 'H73' => "Interjurisdictional Differentials and Their Effects",
 'H74' => "State and Local Borrowing",
 'H75' => "Health, Education, and Welfare",
 'H76' => "Other Expenditure Categories",
 'H77' => "Intergovernmental Relations; Federalism; Secession",
 'H79' => "Other",
 'H8' => "Miscellaneous Issues",
 'H80' => "General",
 'H81' => "Governmental Loans, Loan Guarantees, and Credits",
 'H82' => "Governmental Property",
 'H83' => "Public Administration",
 'H87' => "International Fiscal Issues; International Public Goods",
 'H89' => "Other",
 'I' => "Health, Education, and Welfare",
 'I0' => "General",
 'I00' => "General",
 'I1' => "Health",
 'I10' => "General",
 'I11' => "Analysis of Health Care Markets",
 'I12' => "Health Production",
 'I18' => "Government Policy; Regulation; Public Health",
 'I19' => "Other",
 'I2' => "Education",
 'I20' => "General",
 'I21' => "Analysis of Education",
 'I22' => "Educational Finance",
 'I23' => "Higher Education Research Institutions",
 'I28' => "Government Policy",
 'I29' => "Other",
 'I3' => "Welfare and Poverty",
 'I30' => "General",
 'I31' => "General Welfare",
 'I32' => "Measurement and Analysis of Poverty",
 'I38' => "Government Policy; Provision and Effects of Welfare Programs",
 'I39' => "Other",
 'J' => "Labor and Demographic Economics",
 'J0' => "General",
 'J00' => "General",
 'J01' => "Labor Economics: General",
 'J08' => "Labor Economics Policies",
 'J1' => "Demographic Economics",
 'J10' => "General",
 'J11' => "Demographic Trends and Forecasts",
 'J12' => "Marriage; Marital Dissolution; Family Structure",
 'J13' => "Fertility; Family Planning; Child Care; Children; Youth",
 'J14' => "Economics of the Elderly; Economics of the Handicapped",
 'J15' => "Economics of Minorities and Races; Non-labor Discrimination",
 'J16' => "Economics of Gender; Non-labor Discrimination",
 'J17' => "Value of Life; Forgone Income",
 'J18' => "Public Policy",
 'J19' => "Other",
 'J2' => "Demand and Supply of Labor",
 'J20' => "General",
 'J21' => "Labor Force and Employment, Size, and Structure",
 'J22' => "Time Allocation and Labor Supply",
 'J23' => "Labor Demand",
 'J24' => "Human Capital; Skills; Occupational Choice; Labor Productivity",
 'J26' => "Retirement; Retirement Policies",
 'J28' => "Safety; Job Satisfaction; Related Public Policy",
 'J29' => "Other",
 'J3' => "Wages, Compensation, and Labor Costs",
 'J30' => "General",
 'J31' => "Wage Level and Structure; Wage Differentials",
 'J32' => "Nonwage Labor Costs and Benefits; Private Pensions",
 'J33' => "Compensation Packages; Payment Methods",
 'J38' => "Public Policy",
 'J39' => "Other",
 'J4' => "Particular Labor Markets",
 'J40' => "General",
 'J41' => "Labor Contracts",
 'J42' => "Monopsony; Segmented Labor Markets",
 'J43' => "Agricultural Labor Markets",
 'J44' => "Professional Labor Markets and Occupations",
 'J45' => "Public Sector Labor Markets",
 'J48' => "Public Policy",
 'J49' => "Other",
 'J5' => "Labor-Management Relations, Trade Unions, and Collective Bargaining",
 'J50' => "General",
 'J51' => "Trade Unions: Objectives, Structure, and Effects",
 'J52' => "Dispute Resolution:  Strikes, Arbitration, and Mediation; Collective Bargaining",
 'J53' => "Labor-Management Relations; Industrial Jurisprudence",
 'J54' => "Producer Cooperatives; Labor Managed Firms",
 'J58' => "Public Policy",
 'J59' => "Other",
 'J6' => "Mobility, Unemployment, and Vacancies",
 'J60' => "General",
 'J61' => "Geographic Labor Mobility; Immigrant Workers",
 'J62' => "Job, Occupational, and Intergenerational Mobility",
 'J63' => "Turnover; Vacancies; Layoffs",
 'J64' => "Unemployment: Models, Duration, Incidence, and Job Search",
 'J65' => "Unemployment Insurance; Severance Pay; Plant Closings",
 'J68' => "Public Policy",
 'J69' => "Other",
 'J7' => "Labor Discrimination",
 'J70' => "General",
 'J71' => "Discrimination",
 'J78' => "Public Policy",
 'J79' => "Other",
 'J8' => "Labor Standards: National and International",
 'J80' => "General",
 'J81' => "Working Conditions",
 'J82' => "Labor Force Composition",
 'J83' => "Workers' Rights",
 'J88' => "Public Policy",
 'J89' => "Other",
 'K' => "Law and Economics",
 'K0' => "General",
 'K00' => "General",
 'K1' => "Basic Areas of Law",
 'K10' => "General",
 'K11' => "Property Law",
 'K12' => "Contract Law",
 'K13' => "Tort Law and Product Liability",
 'K14' => "Criminal Law",
 'K19' => "Other",
 'K2' => "Regulation and Business Law",
 'K20' => "General",
 'K21' => "Antitrust Law",
 'K22' => "Corporation and Securities Law",
 'K23' => "Regulated Industries and Administrative Law",
 'K29' => "Other",
 'K3' => "Other Substantive Areas of Law",
 'K30' => "General",
 'K31' => "Labor Law",
 'K32' => "Environmental, Health, and Safety Law",
 'K33' => "International Law",
 'K34' => "Tax Law",
 'K35' => "Personal Bankruptcy Law",
 'K36' => "Family and Personal Law",
 'K39' => "Other",
 'K4' => "Legal Procedure, the Legal System, and Illegal Behavior",
 'K40' => "General",
 'K41' => "Litigation Process",
 'K42' => "Illegal Behavior and the Enforcement of Law",
 'K49' => "Other",
 'L' => "Industrial Organization",
 'L0' => "General",
 'L00' => "General",
 'L1' => "Market Structure, Firm Strategy, and Market Performance",
 'L10' => "General",
 'L11' => "Production, Pricing, and Market Structure; Size Distribution of Firms",
 'L12' => "Monopoly; Monopolization Strategies",
 'L13' => "Oligopoly and Other Imperfect Markets",
 'L14' => "Transactional Relationships; Contracts and Reputation; Networks",
 'L15' => "Information and Product Quality; Standardization and Compatibility",
 'L16' => "Industrial Organization and Macroeconomics; Macroeconomic Industrial Structure; Industrial Price Indices",
 'L17' => "Open Source Products and Markets",
 'L19' => "Other",
 'L2' => "Firm Objectives, Organization, and Behavior",
 'L20' => "General",
 'L21' => "Business Objectives of the Firm",
 'L22' => "Firm Organization and Market Structure",
 'L23' => "Organization of Production",
 'L24' => "Contracting Out; Joint Ventures; Technology Licensing",
 'L25' => "Firm Performance",
 'L26' => "Entrepreneurship",
 'L29' => "Other",
 'L3' => "Nonprofit Organizations and Public Enterprise",
 'L30' => "General",
 'L31' => "Nonprofit Institutions; NGOs",
 'L32' => "Public Enterprises",
 'L33' => "Comparison of Public and Private Enterprises; Privatization; Contracting Out",
 'L38' => "Public Policy",
 'L39' => "Other",
 'L4' => "Antitrust Issues and Policies",
 'L40' => "General",
 'L41' => "Monopolization; Horizontal Anticompetitive Practices",
 'L42' => "Vertical Restraints; Resale Price Maintenance; Quantity Discounts",
 'L43' => "Legal Monopolies and Regulation or Deregulation",
 'L44' => "Antitrust Policy and Public Enterprise, Nonprofit Institutions, and Professional Organizations",
 'L49' => "Other",
 'L5' => "Regulation and Industrial Policy",
 'L50' => "General",
 'L51' => "Economics of Regulation",
 'L52' => "Industrial Policy; Sectoral Planning Methods",
 'L53' => "Enterprise Policy",
 'L59' => "Other",
 'L6' => "Industry Studies: Manufacturing",
 'L60' => "General",
 'L61' => "Metals and Metal Products; Cement; Glass; Ceramics",
 'L62' => "Automobiles; Other Transportation Equipment",
 'L63' => "Microelectronics; Computers; Communications Equipment",
 'L64' => "Other Machinery; Business Equipment; Armaments",
 'L65' => "Chemicals; Rubber; Drugs; Biotechnology",
 'L66' => "Food; Beverages; Cosmetics; Tobacco",
 'L67' => "Other Consumer Nondurables: Clothing, Textiles, Shoes, and Leather",
 'L68' => "Appliances; Other Consumer Durables",
 'L69' => "Other",
 'L7' => "Industry Studies: Primary Products and Construction",
 'L70' => "General",
 'L71' => "Mining, Extraction, and Refining: Hydrocarbon Fuels",
 'L72' => "Mining, Extraction, and Refining: Other Nonrenewable Resources",
 'L73' => "Forest Products",
 'L74' => "Construction",
 'L78' => "Government Policy",
 'L79' => "Other",
 'L8' => "Industry Studies: Services",
 'L80' => "General",
 'L81' => "Retail and Wholesale Trade; e-Commerce",
 'L82' => "Entertainment; Media",
 'L83' => "Sports; Gambling; Recreation; Tourism",
 'L84' => "Personal, Professional, and Business Services",
 'L85' => "Real Estate Services",
 'L86' => "Information and Internet Services; Computer Software",
 'L87' => "Postal and Delivery Services",
 'L88' => "Government Policy",
 'L89' => "Other",
 'L9' => "Industry Studies: Transportation and Utilities",
 'L90' => "General",
 'L91' => "Transportation: General",
 'L92' => "Railroads and Other Surface Transportation",
 'L93' => "Air Transportation",
 'L94' => "Electric Utilities",
 'L95' => "Gas Utilities; Pipelines; Water Utilities",
 'L96' => "Telecommunications",
 'L97' => "Utilities: General",
 'L98' => "Government Policy",
 'L99' => "Other",
 'M' => "Business Administration and Business Economics; Marketing; Accounting",
 'M0' => "General",
 'M00' => "General",
 'M1' => "Business Administration",
 'M10' => "General",
 'M11' => "Production Management",
 'M12' => "Personnel Management",
 'M13' => "New Firms; Startups",
 'M14' => "Corporate Culture; Social Responsibility",
 'M19' => "Other",
 'M2' => "Business Economics",
 'M20' => "General",
 'M21' => "Business Economics",
 'M29' => "Other",
 'M3' => "Marketing and Advertising",
 'M30' => "General",
 'M31' => "Marketing",
 'M37' => "Advertising",
 'M39' => "Other",
 'M4' => "Accounting and Auditing",
 'M40' => "General",
 'M41' => "Accounting",
 'M42' => "Auditing",
 'M49' => "Other",
 'M5' => "Personnel Economics",
 'M50' => "General",
 'M51' => "Firm Employment Decisions; Promotions",
 'M52' => "Compensation and Compensation Methods and Their Effects",
 'M53' => "Training",
 'M54' => "Labor Management",
 'M55' => "Labor Contracting Devices",
 'M59' => "Other",
 'N' => "Economic History",
 'N0' => "General",
 'N00' => "General",
 'N01' => "Development of the Discipline: Historiographical; Sources and Methods",
 'N1' => "Macroeconomics and Monetary Economics; Growth and Fluctuations",
 'N10' => "General, International, or Comparative",
 'N11' => "U.S.; Canada: Pre-1913",
 'N12' => "U.S.; Canada: 1913-",
 'N13' => "Europe: Pre-1913",
 'N14' => "Europe: 1913-",
 'N15' => "Asia including Middle East",
 'N16' => "Latin America; Caribbean",
 'N17' => "Africa; Oceania",
 'N2' => "Financial Markets and Institutions",
 'N20' => "General, International, or Comparative",
 'N21' => "U.S.; Canada: Pre-1913",
 'N22' => "U.S.; Canada: 1913-",
 'N23' => "Europe: Pre-1913",
 'N24' => "Europe: 1913-",
 'N25' => "Asia including Middle East",
 'N26' => "Latin America; Caribbean",
 'N27' => "Africa; Oceania",
 'N3' => "Labor and Consumers, Demography, Education, Health, Income, and Wealth",
 'N30' => "Economic History: Labor and Consumers, Demography, Education, Health, Income and Wealth: General, International, or Comparative",
 'N31' => "Economic History: Labor and Consumers, Demography, Education, Health, Income and Wealth: U.S.; Canada: Pre-1913",
 'N32' => "Economic History: Labor and Consumers, Demography, Education, Health, Income and Wealth: U.S.; Canada: 1913-",
 'N33' => "Economic History: Labor and Consumers, Demography, Education, Health, Income and Wealth: Europe: Pre-1913",
 'N34' => "Economic History: Labor and Consumers, Demography, Education, Health, Income and Wealth: Europe: 1913-",
 'N35' => "Economic History: Labor and Consumers, Demography, Education, Health, Income and Wealth: Asia including Middle East",
 'N36' => "Economic History: Labor and Consumers, Demography, Education, Health, Income and Wealth: Latin America; Caribbean",
 'N37' => "Economic History: Labor and Consumers, Demography, Education, Health, Income and Wealth: Africa; Oceania",
 'N4' => "Government, War, Law, and Regulation",
 'N40' => "General, International, or Comparative",
 'N41' => "U.S.; Canada: Pre-1913",
 'N42' => "U.S.; Canada: 1913-",
 'N43' => "Europe: Pre-1913",
 'N44' => "Europe: 1913-",
 'N45' => "Asia including Middle East",
 'N46' => "Latin America; Caribbean",
 'N47' => "Africa; Oceania",
 'N5' => "Agriculture, Natural Resources, Environment, and Extractive Industries",
 'N50' => "General, International, or Comparative",
 'N51' => "U.S.; Canada: Pre-1913",
 'N52' => "U.S.; Canada: 1913-",
 'N53' => "Europe: Pre-1913",
 'N54' => "Europe: 1913-",
 'N55' => "Asia including Middle East",
 'N56' => "Latin America; Caribbean",
 'N57' => "Africa; Oceania",
 'N6' => "Manufacturing and Construction",
 'N60' => "General, International, or Comparative",
 'N61' => "U.S.; Canada: Pre-1913",
 'N62' => "U.S.; Canada: 1913-",
 'N63' => "Europe: Pre-1913",
 'N64' => "Europe: 1913-",
 'N65' => "Asia including Middle East",
 'N66' => "Latin America; Caribbean",
 'N67' => "Africa; Oceania",
 'N7' => "Transport, Trade, Energy, Technology, and Other Services",
 'N70' => "General, International, or Comparative",
 'N71' => "U.S.; Canada: Pre-1913",
 'N72' => "U.S.; Canada: 1913-",
 'N73' => "Europe: Pre-1913",
 'N74' => "Europe: 1913-",
 'N75' => "Asia including Middle East",
 'N76' => "Latin America; Caribbean",
 'N77' => "Africa; Oceania",
 'N8' => "Micro-Business History",
 'N80' => "General, International, or Comparative",
 'N81' => "U.S.; Canada: Pre-1913",
 'N82' => "U.S.; Canada: 1913-",
 'N83' => "Europe: Pre-1913",
 'N84' => "Europe: 1913-",
 'N85' => "Asia including Middle East",
 'N86' => "Latin America; Caribbean",
 'N87' => "Africa; Oceania",
 'N9' => "Regional and Urban History",
 'N90' => "General, International, or Comparative",
 'N91' => "U.S.; Canada: Pre-1913",
 'N92' => "U.S.; Canada: 1913-",
 'N93' => "Europe: Pre-1913",
 'N94' => "Europe: 1913-",
 'N95' => "Asia including Middle East",
 'N96' => "Latin America; Caribbean",
 'N97' => "Africa; Oceania",
 'O' => "Economic Development, Technological Change, and Growth",
 'O0' => "Economic Development, Technological Change, and Growth: General",
 'O00' => "General",
 'O1' => "Economic Development",
 'O10' => "General",
 'O11' => "Macroeconomic Analyses of Economic Development",
 'O12' => "Microeconomic Analyses of Economic Development",
 'O13' => "Agriculture; Natural Resources; Energy; Environment; Other Primary Products",
 'O14' => "Industrialization; Manufacturing and Service Industries; Choice of Technology",
 'O15' => "Human Resources; Human Development; Income Distribution; Migration",
 'O16' => "Economic Development: Financial Markets; Saving and Capital Investment; Corporate Finance and Governance",
 'O17' => "Formal and Informal Sectors; Shadow Economy; Institutional Arrangements",
 'O18' => "Regional, Urban, and Rural Analyses",
 'O19' => "International Linkages to Development; Role of International Organizations",
 'O2' => "Development Planning and Policy",
 'O20' => "General",
 'O21' => "Planning Models; Planning Policy",
 'O22' => "Project Analysis",
 'O23' => "Fiscal and Monetary Policy in Development",
 'O24' => "Trade Policy; Factor Movement Policy; Foreign Exchange Policy",
 'O25' => "Industrial Policy",
 'O29' => "Other",
 'O3' => "Technological Change; Research and Development",
 'O30' => "General",
 'O31' => "Innovation and Invention: Processes and Incentives",
 'O32' => "Management of Technological Innovation and R&D",
 'O33' => "Technological Change: Choices and Consequences; Diffusion Processes",
 'O34' => "Intellectual Property Rights",
 'O38' => "Government Policy",
 'O39' => "Other",
 'O4' => "Economic Growth and Aggregate Productivity",
 'O40' => "General",
 'O41' => "One, Two, and Multisector Growth Models",
 'O42' => "Monetary Growth Models",
 'O43' => "Institutions and Growth",
 'O47' => "Measurement of Economic Growth; Aggregate Productivity; Cross-Country Output Convergence",
 'O49' => "Other",
 'O5' => "Economywide Country Studies",
 'O50' => "General",
 'O51' => "U.S.; Canada",
 'O52' => "Europe",
 'O53' => "Asia including Middle East",
 'O54' => "Latin America; Caribbean",
 'O55' => "Africa",
 'O56' => "Oceania",
 'O57' => "Comparative Studies of Countries",
 'P' => "Economic Systems",
 'P0' => "General",
 'P00' => "General",
 'P1' => "Capitalist Systems",
 'P10' => "General",
 'P11' => "Planning, Coordination, and Reform",
 'P12' => "Capitalist Enterprises",
 'P13' => "Cooperative Enterprises",
 'P14' => "Property Rights",
 'P16' => "Political Economy",
 'P17' => "Performance and Prospects",
 'P19' => "Other",
 'P2' => "Socialist Systems and Transitional Economies",
 'P20' => "General",
 'P21' => "Planning, Coordination, and Reform",
 'P22' => "Prices",
 'P23' => "Factor and Product Markets; Industry Studies; Population",
 'P24' => "National Income, Product, and Expenditure; Money; Inflation",
 'P25' => "Urban, Rural, and Regional Economics",
 'P26' => "Political Economy; Property Rights",
 'P27' => "Performance and Prospects",
 'P28' => "Natural Resources; Energy; Environment",
 'P29' => "Other",
 'P3' => "Socialist Institutions and Their Transitions",
 'P30' => "General",
 'P31' => "Socialist Enterprises and Their Transitions",
 'P32' => "Collectives; Communes; Agriculture",
 'P33' => "International Trade, Finance, Investment, and Aid",
 'P34' => "Financial Economics",
 'P35' => "Public Economics",
 'P36' => "Socialist Institutions and Their Transitions: Consumer Economics; Health, Education and Training, Welfare, and Poverty",
 'P37' => "Legal Institutions; Illegal Behavior",
 'P39' => "Other",
 'P4' => "Other Economic Systems",
 'P40' => "General",
 'P41' => "Planning, Coordination, and Reform",
 'P42' => "Productive Enterprises; Factor and Product Markets; Prices; Population",
 'P43' => "Public Economics; Financial Economics",
 'P44' => "National Income, Product, and Expenditure; Money; Inflation",
 'P45' => "International Trade, Finance, Investment, and Aid",
 'P46' => "Consumer Economics; Welfare and Poverty",
 'P47' => "Performance and Prospects",
 'P48' => "Political Economy; Legal Institutions; Property Rights",
 'P49' => "Other",
 'P5' => "Comparative Economic Systems",
 'P50' => "General",
 'P51' => "Comparative Analysis of Economic Systems",
 'P52' => "Comparative Studies of Particular Economies",
 'P59' => "Other",
 'Q' => "Agricultural and Natural Resource Economics; Environmental and Ecological Economics",
 'Q0' => "General",
 'Q00' => "General",
 'Q01' => "Sustainable Development",
 'Q1' => "Agriculture",
 'Q10' => "General",
 'Q11' => "Aggregate Supply and Demand Analysis; Prices",
 'Q12' => "Micro Analysis of Farm Firms, Farm Households, and Farm Input Markets",
 'Q13' => "Agricultural Markets and Marketing; Cooperatives; Agribusiness",
 'Q14' => "Agricultural Finance",
 'Q15' => "Land Ownership and Tenure; Land Reform; Land Use; Irrigation",
 'Q16' => "R&D; Agricultural Technology; Agricultural Extension Services",
 'Q17' => "Agriculture in International Trade",
 'Q18' => "Agricultural Policy; Food Policy",
 'Q19' => "Other",
 'Q2' => "Renewable Resources and Conservation",
 'Q20' => "General",
 'Q21' => "Demand and Supply",
 'Q22' => "Fishery; Aquaculture",
 'Q23' => "Forestry",
 'Q24' => "Land",
 'Q25' => "Water",
 'Q26' => "Recreational Aspects of Natural Resources",
 'Q27' => "Renewable Resources and Conservation: Issues in International Trade",
 'Q28' => "Government Policy",
 'Q29' => "Other",
 'Q3' => "Nonrenewable Resources and Conservation",
 'Q30' => "General",
 'Q31' => "Demand and Supply",
 'Q32' => "Exhaustible Resources and Economic Development",
 'Q33' => "Resource Booms",
 'Q34' => "Natural Resources and Domestic and International Conflicts",
 'Q38' => "Government Policy",
 'Q39' => "Other",
 'Q4' => "Energy",
 'Q40' => "General",
 'Q41' => "Demand and Supply",
 'Q42' => "Alternative Energy Sources",
 'Q43' => "Energy and the Macroeconomy",
 'Q48' => "Government Policy",
 'Q49' => "Other",
 'Q5' => "Environmental Economics",
 'Q50' => "General",
 'Q51' => "Valuation of Environmental Effects",
 'Q52' => "Pollution Control Costs; Distributional Effects; Employment Effects",
 'Q53' => "Air Pollution; Water Pollution; Noise; Hazardous Waste; Solid Waste; Recycling",
 'Q54' => "Climate; Natural Disasters",
 'Q55' => "Technological Innovation",
 'Q56' => "Environment and Development; Environment and Trade; Sustainability; Environmental Accounting; Environmental Equity",
 'Q57' => "Ecological Economics: Ecosystem Services; Biodiversity Conservation; Bioeconomics",
 'Q58' => "Government Policy",
 'Q59' => "Other",
 'R' => "Urban, Rural, and Regional Economics",
 'R0' => "General",
 'R00' => "General",
 'R1' => "General Regional Economics",
 'R10' => "General",
 'R11' => "Regional Economic Activity: Growth, Development, and Changes",
 'R12' => "Size and Spatial Distributions of Regional Economic Activity; Interregional Trade",
 'R13' => "General Equilibrium and Welfare Economic Analysis of Regional Economies",
 'R14' => "Land Use Patterns",
 'R15' => "Econometric and Input-Output Models; Other Models",
 'R19' => "Other",
 'R2' => "Household Analysis",
 'R20' => "General",
 'R21' => "Housing Demand",
 'R22' => "Other Demand",
 'R23' => "Regional Migration; Regional Labor Markets; Population",
 'R29' => "Other",
 'R3' => "Production Analysis and Firm Location",
 'R30' => "General",
 'R31' => "Housing Supply and Markets",
 'R32' => "Other Production and Pricing Analysis",
 'R33' => "Nonagricultural and Nonresidential Real Estate Markets",
 'R34' => "Input Demand Analysis",
 'R38' => "Government Policies; Regulatory Policies",
 'R39' => "Other",
 'R4' => "Transportation Systems",
 'R40' => "General",
 'R41' => "Transportation: Demand, Supply, and Congestion; Safety and Accidents; Transportation Noise",
 'R42' => "Government and Private Investment Analysis",
 'R48' => "Government Pricing; Regulatory Policies",
 'R49' => "Other",
 'R5' => "Regional Government Analysis",
 'R50' => "General",
 'R51' => "Finance in Urban and Rural Economies",
 'R52' => "Land Use and Other Regulations",
 'R53' => "Public Facility Location Analysis; Public Investment and Capital Stock",
 'R58' => "Regional Development Policy",
 'R59' => "Other",
 'Y' => "Miscellaneous Categories",
 'Y1' => "Data: Tables and Charts",
 'Y10' => "Data: Tables and Charts",
 'Y2' => "Introductions and Prefaces",
 'Y20' => "Introductions and Prefaces",
 'Y3' => "Book Reviews",
 'Y30' => "Book Reviews",
 'Y4' => "Dissertations",
 'Y40' => "Dissertations",
 'Y5' => "Further Reading",
 'Y50' => "Further Reading",
 'Y6' => "Excerpts",
 'Y60' => "Excerpts",
 'Y8' => "Related Disciplines",
 'Y80' => "Related Disciplines",
 'Y9' => "Other",
 'Y90' => "Other",
 'Z' => "Other Special Topics",
 'Z0' => "General",
 'Z00' => "General",
 'Z1' => "Cultural Economics; Economic Sociology; Economic Anthropology",
 'Z10' => "General",
 'Z11' => "Economics of the Arts and Literature",
 'Z12' => "Religion",
 'Z13' => "Social Norms and Social Capital; Social Networks",
 'Z19' => "Other",

            );
1;

