use ExtUtils::MakeMaker;

sub configure {
  print "Preparing to install ReDIF perl package.\n";
  do ( "Configure" ) 
    or die "Configure failed, so do I";

  eval { require 5.008_000 };

  if ( $@ ) {
    die "You need at least perl 5.8 to use this version of ReDIF-perl\n";
    # that's it
    print "will install Perl 5.6 version of ReDIF-perl\n";
    my $copy = {
                'lib/ReDIF/Parser/Input.pm.5.6' => 'lib/ReDIF/Parser/Input.pm',
                'lib/ReDIF/Unicode.pm.5.6'      => 'lib/ReDIF/Unicode.pm',
                'lib/ReDIF/redif.spec.5.6'      => 'lib/ReDIF/redif.spec',
               };
    
    foreach $f ( keys %$copy ) {
      copy_file( $f , $copy->{$f} );
    }
  }

  eval 'use Carp::Assert;';
  if( @$ ) {
    print
      "You need Carp::Assert module if you plan to use ReDIF::Record.\n",
      "It will help you avoid some errors during make test.\n",
      "Otherwise it is not necessary.\n";
  }
  
}


sub copy_file {
  my $from = shift;
  my $to   = shift;
  
  if ( not -e $from 
       or not -r $from ) {
    return undef;
  }

  if ( open  IN, "<", $from ) { 
    my @input = <IN>;
    close IN;

    if ( open  OUT, ">", $to ) {
      print OUT @input;
      close OUT;
      print "copied $from -> $to\n";

    } else { die; }
  } else { die; }

  return 1;
}


if(not $ENV{MAKEMAKEFILE}) { configure(); }

WriteMakefile(
              NAME      => 'ReDIF-perl',
              VERSION => '2.61',
              'EXE_FILES' => [ 'rech', 'rere' ],
              'PREREQ_PM' => {
              },

              'dist'      => {
                  TARFLAGS => '-cvf',
                  COMPRESS => 'gzip -9f',
                  SUFFIX   => '.gz',
              },

);
