package RePEc::Index::Collection::RePEc;


use ReDIF::Parser qw( redif_open_file redif_get_next_template );
use Carp::Assert;

use RePEc::Index::Collection;

use base qw( RePEc::Index::Collection );

use strict;


sub open_data_file {
  my $self = shift;
  my $filename = shift;
  
  if ( $filename !~ /\.rdf$/i ) {
    return undef;
  }

  if ( $filename =~ m!^/?all/!i ) {
    return undef;
  }

  my $home = $self->{home};
  my $home_len = length( $home );

  my $file_dir = substr( $filename, 0, $home_len );

  assert( $home eq $file_dir );

  my $file_short = substr( $filename, $home_len );

  ###  ignore archive files
  if ( $file_short =~ m!^/all/!i ) { return 0; }

  ###  ignore files in subdirs of series
  my ( $arch ) = ( $file_short =~ m!^/(...)! );

  if ( $arch ne 'per' 
       and $arch ne 'edi' 
       and $file_short !~ 
         m!^/(...)/(?:$arch(?:seri|arch)\.rdf|[^/]{6}/[^/]+)$!i 
       ) { return 0; }


  if ( $self->{filename} ne $filename ) {
    redif_open_file( $filename )
      or return 0;
  }

  my $relative_name = substr( $filename, $home_len );

  $relative_name =~ m/^\/?([a-z]{3})\//i;
  $self->{archive} = lc( $self->{prefix} . ":" . $1 );

}


sub get_next_record {
  my $self = shift;
  my $t = redif_get_next_template();
  if( $t ) {
    return ( lc $t->{handle}[0], $t, $t->{'template-type'}[0], $t->{STARTFPOS}, $t->{MD5SUM} );
  } else {
    return undef;
  }
}


sub check_id {
  my $self = shift;
  my $id   = lc shift;

#  print "Does '$id' belong to '$self->{archive}'?\n";

  return 1 
    if substr( $id, 0, length( $self->{archive} ) ) eq $self->{archive};
}



1;
