$AMF::Spec = {
               'default_namespace' => 'http://amf.openlib.org',
               'adjectives' => {},
               'types' => {
                            'text_type' => [
                                             'text',
                                             [
                                               [
                                                 'variants',
                                                 'book',
                                                 'conferencepaper',
                                                 'article',
                                                 'preprint',
                                                 'bookitem'
                                               ]
                                             ]
                                           ],
                            'XML_NAME' => [
                                            'text',
                                            [
                                              [
                                                're',
                                                '^([\\pL:_][\\pL\\d\\._:\\-]*)$'
                                              ]
                                            ]
                                          ],
                            'DATE' => [
                                        'text',
                                        [
                                          [
                                            're',
                                            '^(\\d{4}(?:-\\d{2}(?:-\\d{2})?)?)$'
                                          ]
                                        ]
                                      ],
                            'reference-container' => {
                                                       'literal' => [
                                                                      'adj'
                                                                    ],
                                                       'context' => [
                                                                      'adj'
                                                                    ]
                                                     },
                            'p/o' => {
                                       'iseditorof' => [
                                                         '_verb',
                                                         'to',
                                                         'text',
                                                         'collection'
                                                       ],
                                       'shortname' => [
                                                        'adj',
                                                        'type',
                                                        'vCard:NickName'
                                                      ],
                                       'date' => [
                                                   'adj',
                                                   'type',
                                                   'event_date'
                                                 ],
                                       'namesuffix' => [
                                                         'adj',
                                                         'type',
                                                         'vCard:N;HonorarySuffix'
                                                       ],
                                       'replaces' => [
                                                       '_verb',
                                                       'to',
                                                       'person',
                                                       'organization'
                                                     ],
                                       'email' => [
                                                    'adj',
                                                    'type',
                                                    'EMAIL'
                                                  ],
                                       'identifier' => [
                                                         'adj',
                                                         'type',
                                                         'dc:identifier'
                                                       ],
                                       'fax' => [
                                                  'adj'
                                                ],
                                       'isreplacedby' => [
                                                           '_verb',
                                                           'to',
                                                           'person',
                                                           'organization'
                                                         ],
                                       'nameprefix' => [
                                                         'adj',
                                                         'type',
                                                         'vCard:N;HonoraryPrefix'
                                                       ],
                                       'familyname' => [
                                                         'adj',
                                                         'type',
                                                         'vCard:N;FamilyName'
                                                       ],
                                       'name' => [
                                                   'adj',
                                                   'type',
                                                   'vCard:FN'
                                                 ],
                                       'postal' => [
                                                     'adj'
                                                   ],
                                       'haspart' => [
                                                      '_verb',
                                                      'to',
                                                      'person',
                                                      'organization'
                                                    ],
                                       'phone' => [
                                                    'adj'
                                                  ],
                                       'ispublisherof' => [
                                                            '_verb',
                                                            'to',
                                                            'text',
                                                            'collection'
                                                          ],
                                       'isauthorof' => [
                                                         '_verb',
                                                         'to',
                                                         'text'
                                                       ],
                                       'givenname' => [
                                                        'adj',
                                                        'type',
                                                        'vCard:N;GivenName'
                                                      ],
                                       'homepage' => [
                                                       'adj',
                                                       'type',
                                                       'URL'
                                                     ],
                                       'ispartof' => [
                                                       '_verb',
                                                       'to',
                                                       'person',
                                                       'organization'
                                                     ],
                                       'additionalname' => [
                                                             'adj',
                                                             'type',
                                                             'vCard:N;AdditionalName'
                                                           ],
                                       'ismaintainerof' => [
                                                             '_verb',
                                                             'to',
                                                             'text',
                                                             'collection'
                                                           ],
                                       'istranslatorof' => [
                                                             '_verb',
                                                             'to',
                                                             'text'
                                                           ]
                                     },
                            'file-container' => {
                                                  'format' => [
                                                                'adj',
                                                                'type',
                                                                'dc:format'
                                                              ],
                                                  'function' => [
                                                                  'adj'
                                                                ],
                                                  'url' => [
                                                             'adj',
                                                             'type',
                                                             'URL'
                                                           ],
                                                  'restriction' => [
                                                                     'adj',
                                                                     'type',
                                                                     'dc:rights'
                                                                   ]
                                                },
                            'event_date' => [
                                              'element',
                                              [
                                                [
                                                  'attribute',
                                                  'event',
                                                  'type',
                                                  'EVENT'
                                                ],
                                                [
                                                  'value',
                                                  'type',
                                                  'DATE'
                                                ]
                                              ]
                                            ],
                            'dctype:text' => {
                                               'haseditor' => [
                                                                '_verb',
                                                                'to',
                                                                'person',
                                                                'organization'
                                                              ],
                                               'hasauthor' => [
                                                                '_verb',
                                                                'to',
                                                                'person',
                                                                'organization'
                                                              ],
                                               'date' => [
                                                           'adj',
                                                           'type',
                                                           'event_date'
                                                         ],
                                               'file' => [
                                                           'adjcontainer',
                                                           'type',
                                                           'file-container'
                                                         ],
                                               'copyright' => [
                                                                'adj'
                                                              ],
                                               'hasaddenum' => [
                                                                 '_verb',
                                                                 'to',
                                                                 'text'
                                                               ],
                                               'haspublisher' => [
                                                                   '_verb',
                                                                   'to',
                                                                   'person',
                                                                   'organization'
                                                                 ],
                                               'haserratum' => [
                                                                 '_verb',
                                                                 'to',
                                                                 'text'
                                                               ],
                                               'keywords' => [
                                                               'adj'
                                                             ],
                                               'email' => [
                                                            'adj',
                                                            'type',
                                                            'EMAIL'
                                                          ],
                                               'identifier' => [
                                                                 'adj'
                                                               ],
                                               'hastranslation' => [
                                                                     '_verb',
                                                                     'to',
                                                                     'text'
                                                                   ],
                                               'isreplacedby' => [
                                                                   '_verb',
                                                                   'to',
                                                                   'text'
                                                                 ],
                                               'iserratumof' => [
                                                                  '_verb',
                                                                  'to',
                                                                  'text'
                                                                ],
                                               'citation' => [
                                                               'adj'
                                                             ],
                                               'isversionof' => [
                                                                  '_verb',
                                                                  'to',
                                                                  'text'
                                                                ],
                                               'serial' => [
                                                             'adjcontainer',
                                                             'type',
                                                             'serial-container'
                                                           ],
                                               'isreferencedby' => [
                                                                     '_verb',
                                                                     'to',
                                                                     'text'
                                                                   ],
                                               'ispartof' => [
                                                               '_verb',
                                                               'to',
                                                               'text',
                                                               'collection'
                                                             ],
                                               'isreviewof' => [
                                                                 '_verb',
                                                                 'to',
                                                                 'text'
                                                               ],
                                               'hasformat' => [
                                                                '_verb',
                                                                'to',
                                                                'text'
                                                              ],
                                               'classification' => [
                                                                     'adj',
                                                                     'type',
                                                                     'classification'
                                                                   ],
                                               'abstract' => [
                                                               'adj'
                                                             ],
                                               'title' => [
                                                            'adj'
                                                          ],
                                               'type' => [
                                                           'adj',
                                                           'type',
                                                           'text_type'
                                                         ],
                                               'istranslationof' => [
                                                                      '_verb',
                                                                      'to',
                                                                      'text'
                                                                    ],
                                               'hascomment' => [
                                                                 '_verb',
                                                                 'to',
                                                                 'text'
                                                               ],
                                               'status' => [
                                                             'adj'
                                                           ],
                                               'hasmaintainer' => [
                                                                    '_verb',
                                                                    'to',
                                                                    'person',
                                                                    'organization'
                                                                  ],
                                               'replaces' => [
                                                               '_verb',
                                                               'to',
                                                               'text'
                                                             ],
                                               'reference' => [
                                                                'adjcontainer',
                                                                'type',
                                                                'reference-container'
                                                              ],
                                               'hassuperviser' => [
                                                                    '_verb',
                                                                    'to',
                                                                    'person',
                                                                    'organization'
                                                                  ],
                                               'references' => [
                                                                 '_verb',
                                                                 'to',
                                                                 'text'
                                                               ],
                                               'iscommenton' => [
                                                                  '_verb',
                                                                  'to',
                                                                  'text'
                                                                ],
                                               'haspart' => [
                                                              '_verb',
                                                              'to',
                                                              'text'
                                                            ],
                                               'displaypage' => [
                                                                  'adj',
                                                                  'type',
                                                                  'URL'
                                                                ],
                                               'hastranslator' => [
                                                                    '_verb',
                                                                    'to',
                                                                    'person',
                                                                    'organization'
                                                                  ],
                                               'isaddenumof' => [
                                                                  '_verb',
                                                                  'to',
                                                                  'text'
                                                                ],
                                               'comment' => [
                                                              'adj'
                                                            ],
                                               'hasversion' => [
                                                                 '_verb',
                                                                 'to',
                                                                 'text'
                                                               ],
                                               'isformatof' => [
                                                                 '_verb',
                                                                 'to',
                                                                 'text'
                                                               ],
                                               'hasreview' => [
                                                                '_verb',
                                                                'to',
                                                                'text'
                                                              ]
                                             },
                            'human_name' => [
                                              'text',
                                              [
                                                [
                                                  're',
                                                  '^(\\w+[\\d\\-\\,\\.\\s\\w]*)$'
                                                ],
                                                [
                                                  'length',
                                                  'min',
                                                  '3'
                                                ]
                                              ]
                                            ],
                            'URL' => [
                                       'text',
                                       [
                                         [
                                           'function',
                                           'ReDIF::URL_Syntax::check_url'
                                         ]
                                       ]
                                     ],
                            'URI' => [
                                       'text',
                                       [
                                         [
                                           're',
                                           '^((?:[^:/?#]+:)?(?://[^/?#]*)?[^?#]*(?:\\?[^#]*)?(?:#.*)?)$'
                                         ]
                                       ]
                                     ],
                            'collection_type' => [
                                                   'text',
                                                   [
                                                     [
                                                       'variants',
                                                       'book',
                                                       'proceedings',
                                                       'journal',
                                                       'classification',
                                                       'serial',
                                                       'archive'
                                                     ]
                                                   ]
                                                 ],
                            'classification:jel1991' => [
                                                          'text',
                                                          [
                                                            [
                                                              'function',
                                                              'AMF::Parser::Datatypes::jel1991'
                                                            ]
                                                          ]
                                                        ],
                            'EMAIL' => [
                                         'text',
                                         [
                                           [
                                             're',
                                             '(?i)^([\\&\\+a-z\\d\\-\\.\\=\\_]+\\@[a-z\\d\\-\\.\\=\\_]+\\.[a-z\\d\\.\\-\\=]+)$'
                                           ]
                                         ]
                                       ],
                            'absoluteURI' => [
                                               'text',
                                               [
                                                 [
                                                   're',
                                                   '^((?:[a-zA-Z][a-zA-Z\\d+.-]*:)(?:(?://[^/?#]*(?:/[^#?]*)?|/[^#?]*)(?:\\?[^#]*)?|[^/].*)(?:#.*)?)$'
                                                 ]
                                               ]
                                             ],
                            'serial-container' => {
                                                    'startpage' => [
                                                                     'adj'
                                                                   ],
                                                    'volume' => [
                                                                  'adj'
                                                                ],
                                                    'journaltitle' => [
                                                                        'adj'
                                                                      ],
                                                    'articlenumber' => [
                                                                         'adj'
                                                                       ],
                                                    'quarter' => [
                                                                   'adj'
                                                                 ],
                                                    'part' => [
                                                                'adj'
                                                              ],
                                                    'issue' => [
                                                                 'adj'
                                                               ],
                                                    'journalabbreviatedtitle' => [
                                                                                   'adj'
                                                                                 ],
                                                    'endpage' => [
                                                                   'adj'
                                                                 ],
                                                    'issuedate' => [
                                                                     'adj',
                                                                     'type',
                                                                     'DATE'
                                                                   ],
                                                    'journalidentifier' => [
                                                                             'adj'
                                                                           ],
                                                    'pages' => [
                                                                 'adj'
                                                               ],
                                                    'season' => [
                                                                  'adj'
                                                                ]
                                                  },
                            'dc:format' => [
                                             'text',
                                             [
                                               [
                                                 'function',
                                                 'AMF::Parser::Datatypes::mime_type'
                                               ]
                                             ]
                                           ],
                            'dctype:collection' => {
                                                     'haseditor' => [
                                                                      '_verb',
                                                                      'to',
                                                                      'person',
                                                                      'organization'
                                                                    ],
                                                     'haspart' => [
                                                                    '_verb',
                                                                    'to',
                                                                    'collection',
                                                                    'text'
                                                                  ],
                                                     'hasmaintainer' => [
                                                                          '_verb',
                                                                          'to',
                                                                          'person',
                                                                          'organization'
                                                                        ],
                                                     'haspublisher' => [
                                                                         '_verb',
                                                                         'to',
                                                                         'person',
                                                                         'organization'
                                                                       ],
                                                     'replaces' => [
                                                                     '_verb',
                                                                     'to',
                                                                     'collection'
                                                                   ],
                                                     'description' => [
                                                                        'adj'
                                                                      ],
                                                     'homepage' => [
                                                                     'adj'
                                                                   ],
                                                     'ispartof' => [
                                                                     '_verb',
                                                                     'to',
                                                                     'collection'
                                                                   ],
                                                     'identifier' => [
                                                                       'adj'
                                                                     ],
                                                     'accesspoint' => [
                                                                        'adj'
                                                                      ],
                                                     'isreplacedby' => [
                                                                         '_verb',
                                                                         'to',
                                                                         'collection'
                                                                       ],
                                                     'title' => [
                                                                  'adj'
                                                                ],
                                                     'abbreviatedtitle' => [
                                                                             'adj'
                                                                           ],
                                                     'type' => [
                                                                 'adj',
                                                                 'type',
                                                                 'collection_type'
                                                               ]
                                                   },
                            'EVENT' => [
                                         'text',
                                         [
                                           [
                                             'variants',
                                             'created',
                                             'modified',
                                             'available',
                                             'issued'
                                           ]
                                         ]
                                       ]
                          },
               'nouns' => {
                            'text' => {
                                        'type' => 'dctype:text'
                                      },
                            'person' => {
                                          'type' => 'p/o'
                                        },
                            'collection' => {
                                              'type' => 'dctype:collection'
                                            },
                            'organization' => {
                                                'type' => 'p/o'
                                              }
                          },
               'verbs' => {
                            'istranslationof' => {
                                                   'reverse' => 'hastranslation'
                                                 },
                            'iseditorof' => {
                                              'reverse' => 'haseditor'
                                            },
                            'hascomment' => {
                                              'reverse' => 'iscommenton'
                                            },
                            'haseditor' => {
                                             'reverse' => 'iseditorof'
                                           },
                            'hasauthor' => {
                                             'reverse' => 'isauthorof'
                                           },
                            'hasaddenum' => {
                                              'reverse' => 'isaddenumof'
                                            },
                            'replaces' => {
                                            'reverse' => 'isreplacedby'
                                          },
                            'haspublisher' => {
                                                'reverse' => 'ispublisherof'
                                              },
                            'hasmaintainer' => {
                                                 'reverse' => 'ismaintainerof'
                                               },
                            'issuperviserof' => {
                                                  'reverse' => 'hassuperviser'
                                                },
                            'haserratum' => {
                                              'reverse' => 'iserratumof'
                                            },
                            'hassuperviser' => {
                                                 'reverse' => 'issuperviserof'
                                               },
                            'hastranslation' => {
                                                  'reverse' => 'istranslationof'
                                                },
                            'references' => {
                                              'reverse' => 'isreferencedby'
                                            },
                            'isreplacedby' => {
                                                'reverse' => 'replaces'
                                              },
                            'iserratumof' => {
                                               'reverse' => 'haserratum'
                                             },
                            'isversionof' => {
                                               'reverse' => 'hasversion'
                                             },
                            'iscommenton' => {
                                               'reverse' => 'hascomment'
                                             },
                            'haspart' => {
                                           'reverse' => 'ispartof'
                                         },
                            'isreferencedby' => {
                                                  'reverse' => 'references'
                                                },
                            'hastranslator' => {
                                                 'reverse' => 'istranslatorof'
                                               },
                            'isauthorof' => {
                                              'reverse' => 'hasauthor'
                                            },
                            'ispublisherof' => {
                                                 'reverse' => 'haspublisher'
                                               },
                            'isaddenumof' => {
                                               'reverse' => 'hasaddenum'
                                             },
                            'ispartof' => {
                                            'reverse' => 'haspart'
                                          },
                            'isreviewof' => {
                                              'reverse' => 'hasreview'
                                            },
                            'hasformat' => {
                                             'reverse' => 'isformatof'
                                           },
                            'hasversion' => {
                                              'reverse' => 'isversionof'
                                            },
                            'istranslatorof' => {
                                                  'reverse' => 'hastranslator'
                                                },
                            'ismaintainerof' => {
                                                  'reverse' => 'hasmaintainer'
                                                },
                            'hasreview' => {
                                             'reverse' => 'isreviewof'
                                           },
                            'isformatof' => {
                                              'reverse' => 'hasformat'
                                            }
                          },
               'main_ns' => 'amf',
               'namespace_uris' => {
                                     'http://www.w3.org/XML/1998/namespace' => 'xml',
                                     'http://amf.openlib.org' => 'amf',
                                     'http://www.w3.org/2001/XMLSchema-instance' => 'xsi'
                                   },
               'depends' => [
                              'ReDIF::URL_Syntax',
                              'AMF::Parser::Datatypes'
                            ],
               'namespaces' => {
                                 'amf' => 'http://amf.openlib.org',
                                 'xsi' => 'http://www.w3.org/2001/XMLSchema-instance',
                                 'xml' => 'http://www.w3.org/XML/1998/namespace'
                               }
             };

require ReDIF::URL_Syntax;

require AMF::Parser::Datatypes;

1;
