package AMF::Parser::Datatypes;

use strict;

require 5.008_000;
require ReDIF::JELcodes;

sub jel1991 {
  my $value = shift;


  if ( not require ReDIF::JELcodes )   {
    warn "can't load JEL codes perl module";
    return undef;     }

  if ( $value =~ /^\d{3}(?:[,;:\s\.]+\d{3})*$/ ) {
    return $value = ''; 
  };

  my $v = uc $value ;
  my @J = split ( /[,;:\s\.]+/, $v );
  
  $value = '';
  foreach (@J) {
    if( /^([A-Z]\d{2})0$/ ) { $_ = $1; }
    if (exists $ReDIF::JELcodes::JEL{$_}) {
      $value .= "$_ ";
    } else {
#      warning( "An invalid JEL code used '$_'" );
    } 
  }
  chop $value; 
  return $value;
}


use ReDIF::MIME_types;

sub mime_type {
  my $value = shift;

  $value = lc $value;
  ### separate
  my ( $main, $ext ) = ( $value =~ m!^([^/]+/[^/]+)(?:;?\s*(.+))?$! );

  if ( not $main ) { return undef; }

  if ( $main =~ /^(?:application|text|image|audio|video)\/x-[\w\-\.]+$/i ) { 
    return $value;
  }

  my $ok = 0;

  ### check the MIME type
  if ( $ReDIF::MIME_types::LIST{$value} ) { 

    ### XXX check extension
#    return( "$main" . ($ext) ? "; $ext" : '' ); 
    return $value;
  };

  return undef;
}


1;
