package AMF::AdjContainer;

#   AMF::AdjContainer class is very much like AMF noun, but not as functional.
#   It may only contain adjectives.

use strict;
use warnings;

use vars qw( @ISA );
@ISA = qw( AMF::Noun );

sub new {
  my $class = shift;
  bless {}, $class;
}

sub verb { die; }
sub adjcontainer { die; }


=pod 
=head1 NAME

AMF::AdjContainer -- class for AMF adjective containers

=head1 SYNOPSIS

 require AMF::AdjContainer; ## not required;
                            ## loaded implicitly via AMF::Noun and AMF::Record
 
 my $file = new AMF::AdjContainer;
 $file -> adjective( "url", {}, $url );

 $text -> adjcontainer( "file", {}, $file );

=head1 DESCRIPTION

Adjective container in AMF is an element, which may contain other adjective
elements; it allows for putting adjectives in a group.  Element
E<lt>fileE<gt> is an example; it is a container for full-text file
adjectives.

AMF::AdjContainer class implements a subset of AMF::Noun (AMF::Record)
interface.  For reasons of the AMF structure logic you can't, for example, put
verbs into an adjective container.

=head1 SEE ALSO

L<AMF::Record>

=head1 AUTHOR

Ivan Kurmanov, http://www.ahinea.com/en/
for ACIS project, http://acis.openlib.org/

=cut



1;
