use strict;

BEGIN {
  my $skip_test = 1;
  eval q! require 5.008_000; $skip_test = 0; !;
  
  if ( $skip_test ) {
    print "1..0 # Skipped: need perl 5.8 for this test\n";
    exit;
  } 
}

print "1..1\n";

use ReDIF::Parser qw( &redif_open_file
                      &redif_get_next_template_good_or_bad
                      &redif_get_next_template
                      &redif_set_parser_options );

use Encode 'is_utf8'; 

redif_set_parser_options( 'remove_newline_from_values' => 1,
			  'build_good_template_text'   => 1,
			  'utf8_output' => 1	     
                         );

binmode(STDOUT, ":utf8");


my( $file ) = 't/unicode/DOMINIQUE_utf8.rdf';

redif_open_file( $file ) or die;


my $t = &redif_get_next_template_good_or_bad();

if ( $t ) {
  my $x = $t->{'name-full'}[0];
  print is_utf8($x) ? "ok" : "not ok" , "\n";

} else {
  die "failed reading template";
}

__END__
print "$t->{ENCODING}\n";
print "$t->{RESULT}\n";
print "$t->{PROBLEMS}\n";
print "$t->{ERRORS}\n";
print "$t->{WARNINGS}\n";
print "$t->{TEXT}\n";

